/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.function.argument;

import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.type.Type;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.function.FunctionInvocationInterceptor;
import pl.decerto.hyperon.runtime.function.argument.FunctionArgumentDataType;
import pl.decerto.hyperon.runtime.function.argument.InvalidFunctionArgumentDataTypeException;
import pl.decerto.hyperon.runtime.function.argument.InvalidFunctionArgumentsNumberException;
import pl.decerto.hyperon.runtime.model.MpFunction;

public class FunctionArgumentDataTypeValidator
implements FunctionInvocationInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FunctionArgumentDataTypeValidator.class);

    @Override
    public void execute(Function function, Object ... args) {
        if (!(function instanceof MpFunction)) {
            return;
        }
        MpFunction mpFunction = (MpFunction)function;
        this.doExecute(mpFunction, args);
    }

    private void doExecute(MpFunction mpFunction, Object ... args) throws InvalidFunctionArgumentDataTypeException {
        String functionName = mpFunction.getName();
        Map<String, String> expectedArgToType = mpFunction.getArgumentToType();
        if (expectedArgToType == null) {
            log.warn("Missing arguments types definition for function '{}'. Skipping validation.", (Object)mpFunction.getId());
            return;
        }
        Collection<String> values = expectedArgToType.values();
        String[] expectedTypes = values.toArray(new String[0]);
        log.info("Validating function '{}' arguments data types. Expected types: {}", (Object)functionName, (Object)expectedTypes);
        int actualArgsNumber = args.length;
        int expectedArgsNumber = expectedTypes.length;
        this.validateArgsNumber(actualArgsNumber, expectedArgsNumber, functionName);
        for (int i = 0; i < expectedArgsNumber; ++i) {
            this.validateArg(i, expectedTypes[i], args, functionName);
        }
    }

    private void validateArgsNumber(int actualArgsNumber, int expectedArgsNumber, String functionName) {
        if (actualArgsNumber != expectedArgsNumber) {
            throw new InvalidFunctionArgumentsNumberException(String.format("Invalid arguments number. Expected: %s, Passed: %s for function '%s'", expectedArgsNumber, actualArgsNumber, functionName));
        }
    }

    private void validateArg(int idx, String expectedTypeName, Object[] args, String functionName) {
        FunctionArgumentDataType expectedArgDataType = FunctionArgumentDataType.of(expectedTypeName);
        boolean isExpectedArgComplex = FunctionArgumentDataType.COMPLEX_DATA_TYPES_NAMES.contains(expectedTypeName);
        if (isExpectedArgComplex) {
            return;
        }
        this.validateConcreteArg(idx, expectedArgDataType, args, functionName);
    }

    private void validateConcreteArg(int idx, FunctionArgumentDataType expectedArgDataType, Object[] args, String functionName) {
        Class<?> preferredClazz;
        Object currentArg = args[idx];
        Class<?> actualClazz = currentArg.getClass();
        if (actualClazz.equals(preferredClazz = expectedArgDataType.getPreferredClazz())) {
            return;
        }
        log.warn("Passed argument of class: {} does not match expected type: {} on position {} for function '{}', trying to convert.", new Object[]{actualClazz.getName(), preferredClazz.getName(), idx, functionName});
        Object object = this.tryConvert(expectedArgDataType.getType(), currentArg, preferredClazz, idx, functionName);
        log.warn("Converting argument on position {} from type {} to type {} for function {} succeeded.", new Object[]{idx, actualClazz.getName(), preferredClazz.getName(), functionName});
        this.overwriteArg(idx, args, object);
    }

    private Object tryConvert(Type<?> type, Object arg, Class<?> preferredClazz, int idx, String functionName) {
        try {
            return type.convert(arg).getValue();
        }
        catch (IllegalArgumentException | HyperonRuntimeException e) {
            throw new InvalidFunctionArgumentDataTypeException(String.format("Invalid argument data type passed on position %s for function '%s'. Passed: %s, Expected: %s", idx, functionName, arg.getClass().getName(), preferredClazz.getName()));
        }
    }

    private void overwriteArg(int idx, Object[] actualArgs, Object object) {
        actualArgs[idx] = object;
    }
}

