/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dev;

import pl.decerto.hyperon.runtime.dev.perspective.RuntimeUserView;

public class UserViewHolder {
    private final String username;
    private final RuntimeUserView userView;
    private final long timestamp;

    public UserViewHolder(String username, RuntimeUserView userView, long timestamp) {
        this.username = username;
        this.userView = userView;
        this.timestamp = timestamp;
    }

    public UserViewHolder(String username, RuntimeUserView userView) {
        this(username, userView, System.currentTimeMillis());
    }

    public boolean isExpired(long currentTimestamp, int timeToLiveSeconds) {
        return currentTimestamp > this.timestamp + (long)(1000 * timeToLiveSeconds);
    }

    public boolean isExpired(int timeToLiveSeconds) {
        return this.isExpired(System.currentTimeMillis(), timeToLiveSeconds);
    }

    public String getUsername() {
        return this.username;
    }

    public RuntimeUserView getUserView() {
        return this.userView;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "UserViewHolder(username=" + this.getUsername() + ", userView=" + this.getUserView() + ")";
    }
}

