/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dev;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.DevModeJdbcDao;
import pl.decerto.hyperon.runtime.dev.RegionInfo;
import pl.decerto.hyperon.runtime.dev.SessionHolder;
import pl.decerto.hyperon.runtime.dev.UserViewHolder;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSession;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeSessionElement;
import pl.decerto.hyperon.runtime.dev.perspective.RuntimeUserView;
import pl.decerto.hyperon.runtime.model.MpElementType;
import pl.decerto.hyperon.runtime.model.MpSchedule;
import pl.decerto.hyperon.runtime.model.MpVersion;
import pl.decerto.hyperon.runtime.provider.MpScheduleProvider;

public class DevModeProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int USERVIEW_CACHE_TTL_SECONDS = 3;
    private final Map<String, SessionHolder> sessionCache = new ConcurrentHashMap<String, SessionHolder>();
    private final Map<String, UserViewHolder> userViewCache = new ConcurrentHashMap<String, UserViewHolder>();
    private final MpScheduleProvider scheduleProvider;
    private final DevModeJdbcDao dao;

    public DevModeProvider(DevModeJdbcDao dao, MpScheduleProvider scheduleProvider) {
        this.scheduleProvider = scheduleProvider;
        this.dao = dao;
    }

    public RuntimeSession getSession(String user) {
        SessionHolder holder = this.sessionCache.get(user);
        if (holder == null) {
            RuntimeSession session = this.loadSession(user);
            holder = new SessionHolder(user, session);
            this.sessionCache.put(user, holder);
        }
        return holder.getSession();
    }

    public RuntimeUserView getUserView(String user) {
        UserViewHolder holder = this.userViewCache.get(user);
        if (holder == null || holder.isExpired(3)) {
            RuntimeUserView view = this.loadUserView(user);
            holder = new UserViewHolder(user, view);
            this.userViewCache.put(user, holder);
        }
        return holder.getUserView();
    }

    public void invalidateUser(String user) {
        this.sessionCache.remove(user);
        this.userViewCache.remove(user);
    }

    public void invalidateSessionCache() {
        this.log.debug("invalidating runtime session cache");
        this.sessionCache.clear();
    }

    Optional<RegionInfo> getRegionForElement(String code, String user, MpElementType elementType) {
        MpSchedule schedule = this.scheduleProvider.cache().getSchedule(code, elementType);
        this.log.trace("found schedule: {}", (Object)schedule);
        String region = schedule != null ? schedule.getRegion() : null;
        String profileCode = schedule != null ? schedule.getProfileCode() : null;
        RuntimeSession session = this.getSession(user);
        if (session != null) {
            for (RuntimeSessionElement wse : session.findElements(code)) {
                if (wse.getElementType() != elementType || !wse.isCreateOrUpdate()) continue;
                return Optional.of(new RegionInfo(wse.getProfileCode(), wse.getRegion()));
            }
        }
        return Objects.isNull(region) ? Optional.empty() : Optional.of(new RegionInfo(profileCode, region));
    }

    public MpVersion getActiveVersion(String region) {
        return this.scheduleProvider.cache().getActiveVersion(region);
    }

    public MpVersion getVersion(String region, String version) {
        return this.scheduleProvider.cache().getVersionData(region, version);
    }

    public MpVersion getUserVersion(String user, String region) {
        RuntimeUserView view = this.getUserView(user);
        String version = view.getVersion(region);
        if (version != null) {
            return this.getVersion(region, version);
        }
        return null;
    }

    public Date getSessionMaxLastUpdate() {
        return this.dao.getSessionMaxLastUpdate();
    }

    private RuntimeSession loadSession(String user) {
        long t = System.currentTimeMillis();
        RuntimeSession session = this.dao.getOpenSession(user);
        this.log.debug("runtime session for user {} loaded, time={}", (Object)user, (Object)(System.currentTimeMillis() - t));
        return session;
    }

    private RuntimeUserView loadUserView(String user) {
        long t = System.currentTimeMillis();
        RuntimeUserView view = this.dao.getUserView(user);
        this.log.debug("runtime userview[{}] loaded, time={}", (Object)user, (Object)(System.currentTimeMillis() - t));
        return view;
    }
}

