/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.result;

import java.math.BigDecimal;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.event.SimulationEvent;
import pl.decerto.hyperon.mp.simulation.event.SimulationListener;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.event.InvestPolicyValueSimulationEvent;
import pl.decerto.hyperon.mp.simulation.life.invest.result.FundResult;
import pl.decerto.hyperon.mp.simulation.life.invest.result.MonthlyResult;
import pl.decerto.hyperon.mp.simulation.life.invest.result.SimulationResult;
import pl.decerto.hyperon.mp.simulation.life.invest.result.SuspenseAccountResult;

public class InvestPolicyValueResultBuilder
implements SimulationListener {
    private SimulationResult result;
    private MonthlyResult currentMonthlyResult;
    private SuspenseAccountResult currentSuspenseResult;

    @Override
    public void onEvent(SimulationEvent e) {
        InvestPolicyValueSimulationEvent event = (InvestPolicyValueSimulationEvent)e;
        String operationName = event.getEventName();
        if ("SIMULATION_STARTED".equals(operationName)) {
            this.afterSimulationInitialize(event);
        } else if ("SAMPLE_PROCESSED".equals(operationName)) {
            this.afterSimulateSample(event);
        } else if ("SIMULATION_FINISHED".equals(operationName)) {
            this.afterSimulationEnd(event);
        }
    }

    private void afterSimulationEnd(InvestPolicyValueSimulationEvent event) {
        InvestPolicyValueSimulationContext simulationContext = event.getSimulationContext();
        this.result.setChargePhasesInOrder(simulationContext.getSimulationChargePhaseInOrder());
        this.result.setSimulationStatus(simulationContext.getSimulationStatus());
        this.result.setMessages(simulationContext.getMessages());
    }

    public void afterSimulationInitialize(InvestPolicyValueSimulationEvent event) {
        this.result = new SimulationResult();
    }

    public void afterSimulateSample(InvestPolicyValueSimulationEvent event) {
        InvestPolicyValueSimulationContext simulationContext = event.getSimulationContext();
        this.currentMonthlyResult = new MonthlyResult(simulationContext.getProcessedMonth());
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationContext.getAccounts()) {
            this.prepareAccountResult(account);
        }
        this.result.addMonthlyResult(this.currentMonthlyResult);
        this.currentMonthlyResult = null;
    }

    private void prepareAccountResult(InvestPolicyValueSimulationContext.SuspenseAccount account) {
        this.currentSuspenseResult = new SuspenseAccountResult(account.getCode());
        this.currentSuspenseResult.setAmountToInvest(account.getAmountToInvest());
        this.currentSuspenseResult.setPaidInPremiumAmount(account.getMonthlyPaidInAmount());
        this.currentSuspenseResult.setTotalPaidInPremiumAmount(account.getTotalPaidInAmount());
        this.currentSuspenseResult.setSurrenderCharge(account.getSurrenderCharge());
        this.currentSuspenseResult.setSurrenderValue(account.getSurrenderValue());
        for (CollectedCharge charge : account.getCollectedCharges()) {
            BigDecimal amount = this.currentSuspenseResult.getChargedAmountPerPhase().get(charge.getPhase());
            amount = amount == null ? charge.getChargedAmount() : amount.add(charge.getChargedAmount());
            this.currentSuspenseResult.getChargedAmountPerPhase().put(charge.getPhase(), amount);
        }
        this.currentSuspenseResult.addCollectedCharges(account.getCollectedCharges());
        for (InvestPolicyValueSimulationContext.Fund fund : account.getFunds()) {
            this.prepareFundResult(fund);
        }
        this.currentMonthlyResult.setTotalPaidInPremiumAmount(SimulationMathematicalFunctions.sum(this.currentMonthlyResult.getTotalPaidInPremiumAmount(), account.getTotalPaidInAmount()));
        this.currentMonthlyResult.setPaidInPremiumAmount(SimulationMathematicalFunctions.sum(this.currentMonthlyResult.getPaidInPremiumAmount(), account.getMonthlyPaidInAmount()));
        this.currentMonthlyResult.setSurrender(SimulationMathematicalFunctions.sum(this.currentMonthlyResult.getSurrender(), account.getSurrenderValue()));
        this.currentMonthlyResult.addSuspenseAccountResult(this.currentSuspenseResult);
        this.currentSuspenseResult = null;
    }

    private void prepareFundResult(InvestPolicyValueSimulationContext.Fund fund) {
        FundResult fundResult = new FundResult(fund.getCode());
        fundResult.setName(fund.getName());
        fundResult.setInitialUnitCount(fund.getUnitsAtBegining());
        fundResult.setInitialUnitPrice(fund.getUnitPriceAtBegining());
        fundResult.setEffectiveRateReturn(fund.getMonthlyEffectiveRateReturn());
        fundResult.setAmountToInvest(fund.getAmountToInvest());
        fundResult.setFinalUnitCount(fund.getUnits());
        fundResult.setFinalUnitPrice(fund.getUnitPrice());
        fundResult.setFinalCapital(fund.getCapital());
        this.currentSuspenseResult.setAmountToInvest(SimulationMathematicalFunctions.sum(this.currentSuspenseResult.getAmountToInvest(), fund.getAmountToInvest()));
        this.currentMonthlyResult.setTotalCapital(SimulationMathematicalFunctions.sum(this.currentMonthlyResult.getTotalCapital(), fund.getCapital()));
        this.currentSuspenseResult.addFundResult(fundResult);
    }

    public SimulationResult getSimulationResult() {
        return this.result;
    }
}

