/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

public class SimulationMpEngineProvider {
    private static final Logger log = LoggerFactory.getLogger(SimulationMpEngineProvider.class);
    private static Map<String, HyperonEngine> mpEngines = new ConcurrentHashMap<String, HyperonEngine>();

    private SimulationMpEngineProvider() {
        throw new UnsupportedOperationException();
    }

    public static void registerEngineForSimulation(String simulationId, HyperonEngine mpEngine) {
        log.debug("enter registerEngineForSimulation({},{})", (Object)simulationId, (Object)mpEngine);
        mpEngines.put(simulationId, mpEngine);
    }

    public static HyperonEngine getEngineForSimulation(String simulationId) {
        log.trace("enter getEngineForSimulation({}), current mpEngines size {}", (Object)simulationId, (Object)mpEngines.size());
        return mpEngines.get(simulationId);
    }

    public static void unregisteEngineForSimulation(String simulationId) {
        log.debug("enter unregisteEngineForSimulation({}), current mpEngines size {}", (Object)simulationId, (Object)mpEngines.size());
        mpEngines.remove(simulationId);
        log.trace("leaving unregisteEngineForSimulation({}), current mpEngines size {}", (Object)simulationId, (Object)mpEngines.size());
    }
}

