/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.context.DefaultContext;
import pl.decerto.hyperon.mp.simulation.Simulator;
import pl.decerto.hyperon.mp.simulation.event.SimulationEvent;
import pl.decerto.hyperon.mp.simulation.event.SimulationListener;
import pl.decerto.hyperon.mp.simulation.event.SimulationListenerSupport;
import pl.decerto.hyperon.mp.simulation.life.invest.AlgorithmProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.SimulationMpEngineProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.event.InvestPolicyValueSimulationEvent;
import pl.decerto.hyperon.mp.simulation.life.invest.params.PolicyValueSimulationParameters;
import pl.decerto.hyperon.mp.simulation.life.invest.params.SuspenseAccountDefinition;
import pl.decerto.hyperon.mp.simulation.samples.RangeBasedSamples;
import pl.decerto.hyperon.mp.simulation.samples.Samples;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class InvestPolicyValueSimulator
implements Simulator {
    private static final Logger log = LoggerFactory.getLogger(InvestPolicyValueSimulator.class);
    private PolicyValueSimulationParameters parameters;
    private SimulationListenerSupport simulationListenerSupport;
    private AlgorithmProvider algorithmProvider;
    private final String simulationId;
    private Map<String, String> previousContextElements = new HashMap<String, String>();

    public InvestPolicyValueSimulator() {
        this.simulationListenerSupport = new SimulationListenerSupport();
        this.simulationId = UUID.randomUUID().toString();
        this.algorithmProvider = new AlgorithmProvider();
    }

    @Override
    public void initialize(Object parameters) {
        this.parameters = (PolicyValueSimulationParameters)parameters;
    }

    @Override
    public void registerListeners(SimulationListener ... listeners) {
        if (listeners != null && listeners.length > 0) {
            this.simulationListenerSupport.registerListeners(Arrays.asList(listeners));
        }
    }

    @Override
    public void execute() {
        this.executePreProcess();
        InvestPolicyValueSimulationContext simulationContext = this.prepareSimulationInstance();
        this.initializeSimulation(simulationContext);
        if (!simulationContext.isAllRequiredParametersValid()) {
            this.finalizeSimulation(simulationContext);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.parameters.getAlgorithmParameterName())) {
            this.simulationBaseOnParameter(simulationContext);
        } else if (this.parameters.getAlgorithmFunctionName() != null) {
            this.simulationBaseOnFunction(simulationContext);
        } else {
            throw new HyperonRuntimeException("No algorithm definition provided");
        }
    }

    private void executePreProcess() {
        if (StringUtils.isBlank((CharSequence)this.parameters.getPreProcessFunctionName())) {
            return;
        }
        HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(this.simulationId);
        Object newParameters = null;
        newParameters = this.parameters.getContext() == null ? mpEngine.call(this.parameters.getPreProcessFunctionName(), new DefaultContext(), this.parameters) : mpEngine.call(this.parameters.getPreProcessFunctionName(), this.parameters.getContext(), this.parameters);
        if (this.shouldChangeParameters(newParameters)) {
            this.parameters = (PolicyValueSimulationParameters)newParameters;
        }
    }

    private boolean shouldChangeParameters(Object newParameters) {
        return newParameters != null;
    }

    private void simulationBaseOnFunction(InvestPolicyValueSimulationContext simulationContext) {
        this.processMonth(simulationContext, null);
    }

    private void simulationBaseOnParameter(InvestPolicyValueSimulationContext simulationContext) {
        List<AlgorithmProvider.AlgorithmStep> steps = this.algorithmProvider.findAlgorithm(this.parameters.getAlgorithmParameterName(), this.simulationId);
        this.processMonth(simulationContext, steps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMonth(InvestPolicyValueSimulationContext simulationContext, List<AlgorithmProvider.AlgorithmStep> steps) {
        Samples<Integer> monthSamples = this.prepareSamples();
        try {
            for (int monthSample : monthSamples) {
                simulationContext.setProcessedSample(monthSample);
                simulationContext.resetMonthCollectedData();
                SimulationLifeContext context = simulationContext.getContext(this.simulationId, this.previousContextElements);
                if (steps != null) {
                    this.executeSampleOperations(steps, simulationContext, context);
                } else {
                    this.executeRhinoAlgoritm(this.parameters.getAlgorithmFunctionName(), simulationContext, context);
                }
                this.previousContextElements = context.getAdditionalContextPaths();
            }
        }
        finally {
            this.finalizeSimulation(simulationContext);
        }
    }

    private void executeRhinoAlgoritm(String functionName, InvestPolicyValueSimulationContext simulationContext, SimulationLifeContext context) {
        try {
            HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId());
            mpEngine.call(functionName, context, new Object[0]);
            SimulationLife simulationData = context.getSimulationData();
            simulationContext.reloadAccounts(simulationData.getAccounts());
            simulationContext.addMessages(context.getCollectedMessages());
        }
        catch (Exception e) {
            String message = "[" + functionName + "]";
            log.error(message, (Throwable)e);
            throw new HyperonRuntimeException(message, e);
        }
        finally {
            this.saveMissedAndAdditionalPaths(simulationContext, context);
        }
        this.riseEvent(InvestPolicyValueSimulationEvent.newEvent(this, "SAMPLE_PROCESSED").withSimulationContext(simulationContext));
    }

    public void setAlgorithmProvider(AlgorithmProvider algorithmProvider) {
        this.algorithmProvider = algorithmProvider;
    }

    public String getSimulationId() {
        return this.simulationId;
    }

    private void executeSampleOperations(List<AlgorithmProvider.AlgorithmStep> steps, InvestPolicyValueSimulationContext simulationContext, SimulationLifeContext context) {
        for (AlgorithmProvider.AlgorithmStep algorithmStep : steps) {
            try {
                simulationContext.setActiveStep(algorithmStep);
                algorithmStep.executeStep(context);
                SimulationLife simulationData = context.getSimulationData();
                simulationContext.reloadAccounts(simulationData.getAccounts());
            }
            catch (Exception e) {
                String message = "[" + algorithmStep.getStepName() + " / " + algorithmStep.getStepFunction() + "]";
                log.error(message, (Throwable)e);
                throw new HyperonRuntimeException(message, e);
            }
            finally {
                this.saveMissedAndAdditionalPaths(simulationContext, context);
            }
        }
        this.riseEvent(InvestPolicyValueSimulationEvent.newEvent(this, "SAMPLE_PROCESSED").withSimulationContext(simulationContext));
    }

    private void saveMissedAndAdditionalPaths(InvestPolicyValueSimulationContext simulationContext, SimulationLifeContext context) {
        simulationContext.addMissingPaths(context.getAndResetMissingPaths());
        simulationContext.addUsedPaths(context.getAndResetUsedAdditionlPaths());
        simulationContext.setSimulationChargePhaseInOrder(context.getSimulationChargePhaseInOrder());
    }

    private Samples<Integer> prepareSamples() {
        return new RangeBasedSamples<Integer>(Integer.class, 0, this.parameters.getInsuranceTermInMonths() - 1, BigDecimal.ONE);
    }

    private InvestPolicyValueSimulationContext prepareSimulationInstance() {
        return new InvestPolicyValueSimulationContext(this.parameters);
    }

    private void riseEvent(SimulationEvent event) {
        this.simulationListenerSupport.dispatchEvent(event);
    }

    private void initializeSimulation(InvestPolicyValueSimulationContext simulationContext) {
        PolicyValueSimulationParameters parameter = (PolicyValueSimulationParameters)simulationContext.getParameters();
        for (SuspenseAccountDefinition accountDefinition : parameter.getSuspenseAccountDefinitions()) {
            this.createAndAddSuspenseAccount(simulationContext, accountDefinition);
        }
        this.riseEvent(InvestPolicyValueSimulationEvent.newEvent(this, "SIMULATION_STARTED").withSimulationContext(simulationContext));
    }

    private void createAndAddSuspenseAccount(InvestPolicyValueSimulationContext simulationInstance, SuspenseAccountDefinition accountDefinition) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = new InvestPolicyValueSimulationContext.SuspenseAccount(accountDefinition);
        simulationInstance.addAccount(account);
    }

    private void finalizeSimulation(InvestPolicyValueSimulationContext simulationContext) {
        SimulationMpEngineProvider.unregisteEngineForSimulation(this.simulationId);
        this.riseEvent(InvestPolicyValueSimulationEvent.newEvent(this, "SIMULATION_FINISHED").withSimulationContext(simulationContext));
    }
}

