/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.mp.simulation.SimulationInstance;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.AlgorithmProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.params.FundDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.params.PaymentDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.params.PolicyValueSimulationParameters;
import pl.decerto.hyperon.mp.simulation.life.invest.params.SuspenseAccountDefinition;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.utils.Messages;

public class InvestPolicyValueSimulationContext
extends SimulationInstance<Integer, PolicyValueSimulationParameters> {
    private static final Logger log = LoggerFactory.getLogger(InvestPolicyValueSimulationContext.class);
    private List<SuspenseAccount> accounts;
    private Set<String> simulationChargePhaseInOrder;
    private SimulationStatus simulationStatus;
    private AlgorithmProvider.AlgorithmStep algorithmStep;
    private List<String> messages = new ArrayList<String>();

    public InvestPolicyValueSimulationContext(PolicyValueSimulationParameters parameters) {
        super(parameters);
        this.accounts = new ArrayList<SuspenseAccount>();
        this.simulationStatus = new SimulationStatus();
        this.checkIfAllRequiredAreSet(parameters);
    }

    void addAccount(SuspenseAccount account) {
        this.accounts.add(account);
    }

    public Integer getProcessedMonth() {
        return (Integer)super.getProcessedSample();
    }

    public void reloadAccounts(List<SuspenseAccount> accounts) {
        this.accounts = new ArrayList<SuspenseAccount>(accounts);
    }

    public SimulationLifeContext getContext(String simulationId, Map<String, String> previousContextElements) {
        HashMap<String, String> fullContextElements = new HashMap<String, String>(previousContextElements);
        fullContextElements.putAll(((PolicyValueSimulationParameters)this.getParameters()).getContextElements());
        return new SimulationLifeContext(this.getSimulationLifeData(), fullContextElements, simulationId);
    }

    public void addMissingPaths(Set<String> missingPaths) {
        this.simulationStatus.addMissingPaths(missingPaths, this.algorithmStep == null ? "" : this.algorithmStep.getStepFunction());
    }

    public void addUsedPaths(Set<String> usedAdditionlPaths) {
        this.simulationStatus.addUsedPaths(usedAdditionlPaths);
    }

    public Map<String, Set<String>> getMissingPaths() {
        return this.simulationStatus.getMissingPaths();
    }

    public Set<String> getMissingRequiredParams() {
        return this.simulationStatus.getMissingRequiredParams();
    }

    public void setActiveStep(AlgorithmProvider.AlgorithmStep algorithmStep) {
        this.algorithmStep = algorithmStep;
    }

    public void addMessages(List<String> messages) {
        this.messages.addAll(messages);
    }

    public boolean isAllRequiredParametersValid() {
        return this.simulationStatus.isAllParametersValid();
    }

    void resetMonthCollectedData() {
        for (SuspenseAccount account : this.accounts) {
            account.reset();
        }
    }

    private SimulationLife getSimulationLifeData() {
        SimulationLife data = new SimulationLife();
        data.setPeriodNumber(this.getProcessedMonth());
        data.setAccounts(this.accounts);
        data.setProductCode(((PolicyValueSimulationParameters)this.getParameters()).getProductCode());
        data.setSimulationVariant(((PolicyValueSimulationParameters)this.getParameters()).getSimulationVariant());
        data.setFundsParam(((PolicyValueSimulationParameters)this.getParameters()).getFundsParams());
        data.setBaseOnParameter(((PolicyValueSimulationParameters)this.getParameters()).getAlgorithmParameterName() != null);
        data.setCapitalControl(((PolicyValueSimulationParameters)this.getParameters()).getCapitalControl());
        return data;
    }

    private void checkIfAllRequiredAreSet(PolicyValueSimulationParameters parameters) {
        if (parameters.getInsuranceTermInMonths() == 0) {
            this.simulationStatus.addMissingRequiredParameter(Messages.message("simulation.parameters.noTerms"));
        }
        if (parameters.getSimulationVariant() == null) {
            this.simulationStatus.addMissingRequiredParameter(Messages.message("simulation.parameters.noVariant"));
        }
        if (parameters.getSuspenseAccountDefinitions() == null || parameters.getSuspenseAccountDefinitions().isEmpty()) {
            this.simulationStatus.addMissingRequiredParameter(Messages.message("simulation.parameters.noAccounts"));
        }
        for (SuspenseAccountDefinition accountDefinition : parameters.getSuspenseAccountDefinitions()) {
            try {
                accountDefinition.isAccountFundsProperlyDefined();
            }
            catch (HyperonRuntimeException e) {
                log.error("", (Throwable)e);
                String accountErrors = accountDefinition.getName() + " - " + e.getMessage();
                this.simulationStatus.addMissingRequiredParameter(accountErrors);
            }
        }
    }

    public List<SuspenseAccount> getAccounts() {
        return this.accounts;
    }

    public Set<String> getSimulationChargePhaseInOrder() {
        return this.simulationChargePhaseInOrder;
    }

    public SimulationStatus getSimulationStatus() {
        return this.simulationStatus;
    }

    public AlgorithmProvider.AlgorithmStep getAlgorithmStep() {
        return this.algorithmStep;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setSimulationChargePhaseInOrder(Set<String> simulationChargePhaseInOrder) {
        this.simulationChargePhaseInOrder = simulationChargePhaseInOrder;
    }

    public static class SimulationStatus {
        private Set<String> missingRequiredParameters = new HashSet<String>();
        private Map<String, Set<String>> missingPaths = new HashMap<String, Set<String>>();
        private Set<String> usedAdditionalPaths = new HashSet<String>();

        public void addMissingRequiredParameter(String message) {
            this.missingRequiredParameters.add(message);
        }

        public Set<String> getMissingRequiredParams() {
            return this.missingRequiredParameters;
        }

        public void addMissingPaths(Set<String> missingPaths, String functionName) {
            for (String path : missingPaths) {
                if (!this.missingPaths.containsKey(path)) {
                    this.missingPaths.put(path, new HashSet());
                }
                this.missingPaths.get(path).add(functionName);
            }
        }

        public void addUsedPaths(Set<String> usedAdditionlPaths) {
            this.usedAdditionalPaths.addAll(usedAdditionlPaths);
        }

        public boolean isAllPathsValid() {
            return this.missingPaths.size() == 0;
        }

        public Map<String, Set<String>> getMissingPaths() {
            return this.missingPaths;
        }

        public Set<String> getUsedAdditionalPaths() {
            return new HashSet<String>(this.usedAdditionalPaths);
        }

        public boolean isAllParametersValid() {
            return this.missingRequiredParameters.size() == 0;
        }
    }

    public static class AmountToInvest {
        private final int periodNumber;
        private final Map<String, BigDecimal> amountToInvestPerSource;

        public AmountToInvest(int periodNumber, Map<String, BigDecimal> amountToInvestPerSource) {
            this.periodNumber = periodNumber;
            this.amountToInvestPerSource = new HashMap<String, BigDecimal>(amountToInvestPerSource);
        }

        public void addPayment(String source, BigDecimal paymentAmount) {
            BigDecimal current = this.amountToInvestPerSource.get(source);
            current = current == null ? BigDecimal.ZERO : current;
            this.amountToInvestPerSource.put(source, SimulationMathematicalFunctions.sum(current, paymentAmount));
        }

        public BigDecimal getAmountInPeriod(int start, int end, String source) {
            BigDecimal result = BigDecimal.ZERO;
            if (this.periodNumber >= start && this.periodNumber <= end) {
                if (source == null) {
                    for (Map.Entry<String, BigDecimal> amount : this.amountToInvestPerSource.entrySet()) {
                        result = result.add(amount.getValue());
                    }
                } else if (this.amountToInvestPerSource.get(source) != null) {
                    result = result.add(this.amountToInvestPerSource.get(source));
                }
            }
            return result;
        }
    }

    public static class FundCharge {
        FundDefinition fundDefinition;
        ChargeDefinition chargeDefinition;
        ChargeValueDefinition chargeValue;
        BigDecimal units;

        public FundCharge(FundDefinition fundDefinition, BigDecimal units, ChargeDefinition chargeDefinition, ChargeValueDefinition chargeValue) {
            this.fundDefinition = fundDefinition;
            this.units = units;
            this.chargeDefinition = chargeDefinition;
            this.chargeValue = chargeValue;
        }

        public FundDefinition getFundDefinition() {
            return this.fundDefinition;
        }

        public ChargeDefinition getChargeDefinition() {
            return this.chargeDefinition;
        }

        public ChargeValueDefinition getChargeValue() {
            return this.chargeValue;
        }

        public BigDecimal getUnits() {
            return this.units;
        }
    }

    public static class Fund {
        FundDefinition fundDefinition;
        String name;
        BigDecimal unitsAtBegining = BigDecimal.ZERO;
        BigDecimal unitPriceAtBegining = BigDecimal.ZERO;
        BigDecimal capitalAtBegining = BigDecimal.ZERO;
        BigDecimal unitPrice = BigDecimal.ZERO;
        BigDecimal units = BigDecimal.ZERO;
        BigDecimal capital = BigDecimal.ZERO;
        BigDecimal amountToInvest = BigDecimal.ZERO;
        BigDecimal boughtUnits = BigDecimal.ZERO;
        BigDecimal monthlyEffectiveRateReturn = BigDecimal.ZERO;
        BigDecimal annualRateReturn = BigDecimal.ZERO;
        BigDecimal unitsTransfer = BigDecimal.ZERO;

        public Fund(FundDefinition fundDefinition) {
            this.fundDefinition = fundDefinition;
            this.name = fundDefinition.getName();
        }

        public String getCode() {
            return this.fundDefinition.getCode();
        }

        public BigDecimal getSplit() {
            return this.fundDefinition.getSplit();
        }

        public void transferUnits(BigDecimal unitsTransfer) {
            this.units = SimulationMathematicalFunctions.sum(this.units, unitsTransfer);
            this.unitsTransfer = SimulationMathematicalFunctions.sum(this.unitsTransfer, unitsTransfer);
        }

        public BigDecimal calculateUnitsAverage() {
            return SimulationMathematicalFunctions.average(this.getUnitsAtBegining(), this.getUnits());
        }

        public FundDefinition getFundDefinition() {
            return this.fundDefinition;
        }

        public String getName() {
            return this.name;
        }

        public BigDecimal getUnitsAtBegining() {
            return this.unitsAtBegining;
        }

        public BigDecimal getUnitPriceAtBegining() {
            return this.unitPriceAtBegining;
        }

        public BigDecimal getCapitalAtBegining() {
            return this.capitalAtBegining;
        }

        public BigDecimal getUnitPrice() {
            return this.unitPrice;
        }

        public BigDecimal getUnits() {
            return this.units;
        }

        public BigDecimal getCapital() {
            return this.capital;
        }

        public BigDecimal getAmountToInvest() {
            return this.amountToInvest;
        }

        public BigDecimal getBoughtUnits() {
            return this.boughtUnits;
        }

        public BigDecimal getMonthlyEffectiveRateReturn() {
            return this.monthlyEffectiveRateReturn;
        }

        public BigDecimal getAnnualRateReturn() {
            return this.annualRateReturn;
        }

        public BigDecimal getUnitsTransfer() {
            return this.unitsTransfer;
        }

        public void setFundDefinition(FundDefinition fundDefinition) {
            this.fundDefinition = fundDefinition;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUnitsAtBegining(BigDecimal unitsAtBegining) {
            this.unitsAtBegining = unitsAtBegining;
        }

        public void setUnitPriceAtBegining(BigDecimal unitPriceAtBegining) {
            this.unitPriceAtBegining = unitPriceAtBegining;
        }

        public void setCapitalAtBegining(BigDecimal capitalAtBegining) {
            this.capitalAtBegining = capitalAtBegining;
        }

        public void setUnitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
        }

        public void setUnits(BigDecimal units) {
            this.units = units;
        }

        public void setCapital(BigDecimal capital) {
            this.capital = capital;
        }

        public void setAmountToInvest(BigDecimal amountToInvest) {
            this.amountToInvest = amountToInvest;
        }

        public void setBoughtUnits(BigDecimal boughtUnits) {
            this.boughtUnits = boughtUnits;
        }

        public void setMonthlyEffectiveRateReturn(BigDecimal monthlyEffectiveRateReturn) {
            this.monthlyEffectiveRateReturn = monthlyEffectiveRateReturn;
        }

        public void setAnnualRateReturn(BigDecimal annualRateReturn) {
            this.annualRateReturn = annualRateReturn;
        }

        public void setUnitsTransfer(BigDecimal unitsTransfer) {
            this.unitsTransfer = unitsTransfer;
        }
    }

    public static class SuspenseAccount {
        private SuspenseAccountDefinition accountDefinition;
        Map<String, Fund> funds;
        List<FundCharge> debt;
        private Map<String, BigDecimal> amountToInvestPerSource;
        private Map<String, AmountToInvest> previousAmountToInvestPerSource;
        BigDecimal monthlyPaidInAmount = BigDecimal.ZERO;
        BigDecimal totalPaidInAmount = BigDecimal.ZERO;
        BigDecimal firstYearPaidInAmount = BigDecimal.ZERO;
        List<CollectedCharge> collectedCharges;
        private BigDecimal amountToInvest;
        BigDecimal capital = BigDecimal.ZERO;
        BigDecimal surrenderCharge = BigDecimal.ZERO;
        BigDecimal surrenderValue = BigDecimal.ZERO;

        public SuspenseAccount(SuspenseAccountDefinition accountDefinition) {
            this.initAccountDefinition(accountDefinition);
            this.amountToInvestPerSource = new HashMap<String, BigDecimal>();
            this.previousAmountToInvestPerSource = new HashMap<String, AmountToInvest>();
            this.funds = new LinkedHashMap<String, Fund>();
            this.debt = new ArrayList<FundCharge>();
            this.collectedCharges = new ArrayList<CollectedCharge>();
        }

        public void addFund(Fund fund) {
            this.funds.put(fund.getCode(), fund);
        }

        public void addCollectedCharges(Collection<CollectedCharge> charges) {
            this.collectedCharges.addAll(charges);
        }

        public void addCollectedCharge(CollectedCharge collectedCharge) {
            this.collectedCharges.add(collectedCharge);
        }

        public Fund getFund(String code) {
            return this.funds.get(code);
        }

        public Collection<Fund> getFunds() {
            return this.funds.values();
        }

        public String getCode() {
            return this.accountDefinition.getName();
        }

        public void reset() {
            this.collectedCharges.clear();
        }

        public void addChargeToDebt(FundCharge charge) {
            this.debt.add(charge);
        }

        public List<FundDefinition> getFundDefinitions() {
            return this.accountDefinition.getFundDefinitions();
        }

        public List<PaymentDefinition> getPaymentDefinitions() {
            return this.accountDefinition.getPaymentDefinitions();
        }

        public BigDecimal calculateCurrentAccountCapital() {
            return this.sumFundsCapital();
        }

        public BigDecimal calculateAccountCapitalAtBeginning() {
            return this.sumFundsCapitalAtBeginning();
        }

        private BigDecimal sumFundsCapitalAtBeginning() {
            BigDecimal capital = BigDecimal.ZERO;
            for (Fund fund : this.getFunds()) {
                capital = capital.add(fund.getCapitalAtBegining());
            }
            return SimulationMathematicalFunctions.scale(capital, 10);
        }

        private BigDecimal sumFundsCapital() {
            BigDecimal capital = BigDecimal.ZERO;
            for (Fund fund : this.getFunds()) {
                capital = capital.add(fund.getCapital());
            }
            return SimulationMathematicalFunctions.scale(capital, 10);
        }

        public BigDecimal calculateAmmountToInvestInPeriod(int start, int end, String source) {
            BigDecimal result = BigDecimal.ZERO;
            for (Map.Entry<String, AmountToInvest> amountToInvest : this.previousAmountToInvestPerSource.entrySet()) {
                result = result.add(amountToInvest.getValue().getAmountInPeriod(start, end, source));
            }
            return result;
        }

        public List<String> getFundCodes() {
            return new ArrayList<String>(this.funds.keySet());
        }

        public BigDecimal getTotalUnits() {
            BigDecimal totalUnits = BigDecimal.ZERO;
            for (Fund fund : this.getFunds()) {
                totalUnits = totalUnits.add(fund.getUnits());
            }
            return SimulationMathematicalFunctions.scale(totalUnits, 10);
        }

        public void saveAmountToInvestPerSource(int processedMonth, String source, BigDecimal paymentAmount) {
            if (this.previousAmountToInvestPerSource.get("" + processedMonth) == null) {
                HashMap<String, BigDecimal> payments = new HashMap<String, BigDecimal>();
                payments.put(source, paymentAmount);
                this.previousAmountToInvestPerSource.put(processedMonth + "", new AmountToInvest(processedMonth, payments));
            } else {
                this.previousAmountToInvestPerSource.get("" + processedMonth).addPayment(source, paymentAmount);
            }
        }

        private void initAccountDefinition(SuspenseAccountDefinition accountDefinition) {
            this.accountDefinition = new SuspenseAccountDefinition(accountDefinition.getName());
            this.accountDefinition.setFundDefinitions(new ArrayList<FundDefinition>(accountDefinition.getFundDefinitions()));
            ArrayList<PaymentDefinition> paymentDefinitions = new ArrayList<PaymentDefinition>(accountDefinition.getPaymentDefinitions().size());
            for (PaymentDefinition paymentDefinition : accountDefinition.getPaymentDefinitions()) {
                if (paymentDefinition instanceof PaymentDefinition.RegularPaymentDefinition) {
                    paymentDefinitions.add(new PaymentDefinition.RegularPaymentDefinition((PaymentDefinition.RegularPaymentDefinition)paymentDefinition));
                    continue;
                }
                if (!(paymentDefinition instanceof PaymentDefinition.IrregularPaymentDefinition)) continue;
                paymentDefinitions.add(new PaymentDefinition.IrregularPaymentDefinition((PaymentDefinition.IrregularPaymentDefinition)paymentDefinition));
            }
            this.accountDefinition.setPaymentDefinitions(paymentDefinitions);
            this.accountDefinition.setStartingMonth(accountDefinition.getStartingMonth());
        }

        public SuspenseAccountDefinition getAccountDefinition() {
            return this.accountDefinition;
        }

        public List<FundCharge> getDebt() {
            return this.debt;
        }

        public Map<String, BigDecimal> getAmountToInvestPerSource() {
            return this.amountToInvestPerSource;
        }

        public Map<String, AmountToInvest> getPreviousAmountToInvestPerSource() {
            return this.previousAmountToInvestPerSource;
        }

        public BigDecimal getMonthlyPaidInAmount() {
            return this.monthlyPaidInAmount;
        }

        public BigDecimal getTotalPaidInAmount() {
            return this.totalPaidInAmount;
        }

        public BigDecimal getFirstYearPaidInAmount() {
            return this.firstYearPaidInAmount;
        }

        public List<CollectedCharge> getCollectedCharges() {
            return this.collectedCharges;
        }

        public BigDecimal getAmountToInvest() {
            return this.amountToInvest;
        }

        public BigDecimal getCapital() {
            return this.capital;
        }

        public BigDecimal getSurrenderCharge() {
            return this.surrenderCharge;
        }

        public BigDecimal getSurrenderValue() {
            return this.surrenderValue;
        }

        public void setAccountDefinition(SuspenseAccountDefinition accountDefinition) {
            this.accountDefinition = accountDefinition;
        }

        public void setFunds(Map<String, Fund> funds) {
            this.funds = funds;
        }

        public void setDebt(List<FundCharge> debt) {
            this.debt = debt;
        }

        public void setAmountToInvestPerSource(Map<String, BigDecimal> amountToInvestPerSource) {
            this.amountToInvestPerSource = amountToInvestPerSource;
        }

        public void setPreviousAmountToInvestPerSource(Map<String, AmountToInvest> previousAmountToInvestPerSource) {
            this.previousAmountToInvestPerSource = previousAmountToInvestPerSource;
        }

        public void setMonthlyPaidInAmount(BigDecimal monthlyPaidInAmount) {
            this.monthlyPaidInAmount = monthlyPaidInAmount;
        }

        public void setTotalPaidInAmount(BigDecimal totalPaidInAmount) {
            this.totalPaidInAmount = totalPaidInAmount;
        }

        public void setFirstYearPaidInAmount(BigDecimal firstYearPaidInAmount) {
            this.firstYearPaidInAmount = firstYearPaidInAmount;
        }

        public void setCollectedCharges(List<CollectedCharge> collectedCharges) {
            this.collectedCharges = collectedCharges;
        }

        public void setAmountToInvest(BigDecimal amountToInvest) {
            this.amountToInvest = amountToInvest;
        }

        public void setCapital(BigDecimal capital) {
            this.capital = capital;
        }

        public void setSurrenderCharge(BigDecimal surrenderCharge) {
            this.surrenderCharge = surrenderCharge;
        }

        public void setSurrenderValue(BigDecimal surrenderValue) {
            this.surrenderValue = surrenderValue;
        }
    }
}

