/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.date;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class SimpleDateFormatPool {
    private static ThreadLocal<Map<String, SimpleDateFormat>> pool = ThreadLocal.withInitial(HashMap::new);

    public static SimpleDateFormat get(String pattern) {
        Map<String, SimpleDateFormat> map = pool.get();
        return map.computeIfAbsent(pattern, ptr -> {
            SimpleDateFormat sdf = new SimpleDateFormat((String)ptr);
            sdf.setLenient(false);
            return sdf;
        });
    }
}

