/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.Date;
import pl.decerto.hyperon.runtime.dev.DevModeProvider;
import pl.decerto.hyperon.runtime.sync.BaseWatcher;

public class DevModeWatcher
extends BaseWatcher
implements Runnable {
    private final DevModeProvider provider;
    private Date timestamp;

    public DevModeWatcher(DevModeProvider provider) {
        this.provider = provider;
    }

    @Override
    public void doWatch() {
        Date maxLastupdate = this.provider.getSessionMaxLastUpdate();
        if (this.possibleModification(maxLastupdate)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("newer last update: {}", (Object)this.print(maxLastupdate));
            }
            this.provider.invalidateSessionCache();
            this.timestamp = maxLastupdate;
            if (this.log.isDebugEnabled()) {
                this.log.debug("last update set to: {}", (Object)this.print(this.timestamp));
            }
        }
    }

    @Override
    protected String getWatcherName() {
        return "devmode-watcher";
    }

    private boolean possibleModification(Date lastUpdate) {
        return lastUpdate != null && (this.timestamp == null || lastUpdate.getTime() > this.timestamp.getTime());
    }
}

