/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.provider.external;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.parameter.ParameterEntry;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.runtime.core.extdatasource.ExternalDataSourceProvider;
import pl.decerto.hyperon.runtime.dao.MiniJdbcTemplate;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.helper.TypeConverter;
import pl.decerto.hyperon.runtime.model.MpLevel;
import pl.decerto.hyperon.runtime.model.MpParameter;
import pl.decerto.hyperon.runtime.model.MpParameterEntry;
import pl.decerto.hyperon.runtime.provider.external.ExtRowCallbackHandler;
import pl.decerto.hyperon.runtime.provider.external.ExtSql;
import pl.decerto.hyperon.runtime.provider.external.ExtSqlParser;

public class ExtSqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExtSqlExecutor.class);
    private static final int DEFAULT_FETCH_SIZE = 100;
    private static final int MATRIX_FETCH_SIZE = 500;
    private final TypeConverter typeConverter = new TypeConverter();
    private final ExternalDataSourceProvider dataSourceProvider;
    private final ConnectionInterceptor connectionInterceptor;

    public ExtSqlExecutor(ExternalDataSourceProvider dataSourceProvider, ConnectionInterceptor connectionInterceptor) {
        this.dataSourceProvider = dataSourceProvider;
        this.connectionInterceptor = connectionInterceptor;
    }

    public Set<ParameterEntry> findEntries(MpParameter def, String[] inputValues) {
        if (log.isDebugEnabled()) {
            log.debug("enter findEntries, param={}, input={}", (Object)def.getName(), (Object)Arrays.toString(inputValues));
        }
        boolean trace = log.isTraceEnabled();
        String template = def.getExternalNonMemQuery();
        log.trace("using ext non-mem query: {}", (Object)template);
        ExtSql ext = ExtSqlParser.parse(template);
        int argCnt = ext.getArgs().size();
        Object[] args = new Object[argCnt];
        for (int i = 0; i < argCnt; ++i) {
            String argName = ext.getArg(i);
            int levelIx = def.getInputLevelIndex(argName);
            MpLevel level = def.getLevel(levelIx);
            String textValue = inputValues[levelIx];
            Object argValue = this.castArgToType(textValue, level);
            if (trace) {
                log.trace("binding arg: {} ({}) -> {} ({})", new Object[]{argName, level.getType(), argValue, this.className(argValue)});
            }
            args[i] = argValue;
        }
        HashSet<ParameterEntry> result = new HashSet<ParameterEntry>(8);
        int outCnt = def.getOutputLevels();
        DataSource dataSource = this.dataSourceProvider.getDataSource(def.getExternalDataSource());
        MiniJdbcTemplate jdbc = new MiniJdbcTemplate(dataSource, this.connectionInterceptor);
        jdbc.setFetchSize(100);
        jdbc.query(ext.getSql(), args, rs -> {
            String[] out = new String[outCnt];
            for (int i = 0; i < outCnt; ++i) {
                Object obj = rs.getObject(i + 1);
                String text = null;
                if (obj != null) {
                    MpLevel level = def.getOutputLevel(i);
                    text = this.typeConverter.toHolder(obj, level.getType()).getString();
                }
                out[i] = text;
                if (!trace) continue;
                log.trace("reading out[{}]: {} ({}) -> {} (String)", new Object[]{i, obj, this.className(obj), text});
            }
            String[] row = this.merge(inputValues, out);
            result.add(new MpParameterEntry(row));
        });
        log.debug("leave get, result = {}", result);
        return result;
    }

    public void fetchMatrixExt(MpParameter p) {
        log.debug("enter fetchMatrixExt, p={}", (Object)p);
        long pid = p.getId();
        String sql = p.getExternalInMemQuery();
        DataSource dataSource = this.dataSourceProvider.getDataSource(p.getExternalDataSource());
        log.trace("using datasource: {}", (Object)dataSource);
        log.trace("using query: {}", (Object)sql);
        MiniJdbcTemplate jdbc = new MiniJdbcTemplate(dataSource, this.connectionInterceptor);
        jdbc.setFetchSize(500);
        jdbc.query(sql, new ExtRowCallbackHandler(p));
        log.debug("leave fetchMatrixExt, pid={}, size={}", (Object)pid, (Object)p.getEntries().size());
    }

    final String[] merge(String[] a, String[] b) {
        String[] r = new String[a.length + b.length];
        System.arraycopy(a, 0, r, 0, a.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        return r;
    }

    private String className(Object obj) {
        return obj != null ? obj.getClass().getSimpleName() : null;
    }

    private Object castArgToType(String textValue, MpLevel level) {
        if (StringUtils.isBlank((CharSequence)textValue)) {
            return null;
        }
        String type = level.getType();
        ValueHolder holder = this.typeConverter.toHolder((Object)textValue, type);
        return holder.getValue();
    }
}

