/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.prefetch;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.runtime.prefetch.Initializer;

public class PrefetcherRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(PrefetcherRunnable.class);
    private static final int DEFAULT_PAUSE_AFTER_FAILURE_SECONDS = 10;
    private final List<String> toPrefetch;
    private final Initializer initializer;
    private final int pauseAfterFailure;

    PrefetcherRunnable(List<String> toPrefetch, Initializer initializer) {
        this.toPrefetch = toPrefetch;
        this.initializer = initializer;
        this.pauseAfterFailure = 10;
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug(Printer.print(this.toPrefetch, "code to be prefetched"));
        }
        long t = System.nanoTime();
        this.initializeCode();
        log.debug("finished code initialization, time={} ms", (Object)(System.nanoTime() - t));
    }

    private void initializeCode() {
        int i = 0;
        int sizeOfTheListToPrefetch = this.toPrefetch.size();
        for (String code : this.toPrefetch) {
            log.debug("initializing {}/{} - {}", new Object[]{++i, sizeOfTheListToPrefetch, code});
            try {
                this.initializer.initialize(code);
            }
            catch (RuntimeException e) {
                log.error("failed to initialize code", (Throwable)e);
                this.pauseAfterFailure();
            }
        }
    }

    private void pauseAfterFailure() {
        this.pause(this.pauseAfterFailure);
    }

    private void pause(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            log.error("pause interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

