/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.prefetch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.UnknownParameterException;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.HyperonEngineImpl;
import pl.decerto.hyperon.runtime.prefetch.Initializer;

public class ParamInitializerImpl
implements Initializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HyperonEngineImpl engine;

    public ParamInitializerImpl(HyperonEngineImpl engine) {
        this.engine = engine;
    }

    @Override
    public void initialize(String paramCode) {
        try {
            this.engine.get(paramCode, new HyperonContext(new Object[0]));
        }
        catch (ParameterValueNotFoundException e) {
            this.log.error("expected exception", (Throwable)e);
        }
        catch (UnknownParameterException e) {
            this.log.warn("parameter not found: {}", (Object)paramCode);
            this.log.error("failed to initialize", (Throwable)e);
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }
}

