/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model.region;

import java.util.Objects;
import pl.decerto.hyperon.runtime.model.region.RegionIdentifier;

public final class RegionVersionIdentifier {
    private final RegionIdentifier regionIdentifier;
    private final String version;

    public RegionVersionIdentifier(String profileCode, String regionCode, String version) {
        this(new RegionIdentifier(profileCode, regionCode), version);
    }

    public RegionVersionIdentifier(RegionIdentifier regionIdentifier, String version) {
        this.regionIdentifier = regionIdentifier;
        this.version = version;
    }

    public String getProfileCode() {
        return this.regionIdentifier.getProfileCode();
    }

    public String getRegionCode() {
        return this.regionIdentifier.getRegionCode();
    }

    public String getVersion() {
        return this.version;
    }

    public RegionIdentifier getRegionIdentifier() {
        return this.regionIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionVersionIdentifier that = (RegionVersionIdentifier)o;
        return Objects.equals(this.regionIdentifier, that.regionIdentifier) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.regionIdentifier, this.version);
    }

    public String toString() {
        return "RegionVersionIdentifier{regionIdentifier=" + this.regionIdentifier + ", version='" + this.version + '\'' + '}';
    }
}

