/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.Date;
import java.util.Objects;
import org.smartparam.engine.types.date.SimpleDateFormatPool;

public class MpVersion {
    private final int id;
    private final int regionId;
    private final String region;
    private final String number;
    private final boolean active;
    private final Date lastUpdate;
    private final String profileCode;

    public MpVersion(int id, int regionId, String profileCode, String region, String number, boolean active, Date lastUpdate) {
        this.id = id;
        this.regionId = regionId;
        this.profileCode = profileCode;
        this.region = region;
        this.number = number;
        this.active = active;
        this.lastUpdate = lastUpdate;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public String getRegion() {
        return this.region;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public String getProfileCode() {
        return this.profileCode;
    }

    private String print(Date d) {
        return d != null ? SimpleDateFormatPool.get("yyyy-MM-dd HH:mm:ss.SSS").format(d) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpVersion mpVersion = (MpVersion)o;
        return this.id == mpVersion.id && this.regionId == mpVersion.regionId && this.active == mpVersion.active && Objects.equals(this.region, mpVersion.region) && Objects.equals(this.number, mpVersion.number) && Objects.equals(this.lastUpdate, mpVersion.lastUpdate) && Objects.equals(this.profileCode, mpVersion.profileCode);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.regionId, this.region, this.number, this.active, this.lastUpdate, this.profileCode);
    }

    public String toString() {
        return "MpVersion[r=" + this.region + '#' + this.regionId + ", profileCode=" + this.profileCode + ", rvid=" + this.id + ", number=" + this.number + ", active=" + this.active + ", last=" + this.print(this.lastUpdate) + ']';
    }
}

