/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.domain.AttributeValueProvider;
import pl.decerto.hyperon.runtime.dao.BaseDao;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.dao.exception.EmptyResultDaoException;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.dao.util.LoadTime;
import pl.decerto.hyperon.runtime.dao.util.RowMapper;
import pl.decerto.hyperon.runtime.model.HyperonAttributeDefinitionImpl;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectImpl;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectTypeImpl;
import pl.decerto.hyperon.runtime.model.MpDomainAttributeDto;
import pl.decerto.hyperon.runtime.model.MpOpenSession;
import pl.decerto.hyperon.runtime.model.MpReferenceDto;
import pl.decerto.hyperon.runtime.model.MpRegionCached;
import pl.decerto.hyperon.runtime.model.MpVersion;
import pl.decerto.hyperon.runtime.profiler.attribute.AttributeKey;
import pl.decerto.hyperon.runtime.profiler.engine.AttributeEngineProfiler;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;

public class DomainCacheJdbcDao
extends BaseDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainCacheJdbcDao.class);
    private static final int DEFAULT_FETCH_SIZE = 50;
    private static final Date DATE_1900;
    private static final String COLLECTION_CODE = "collectionCode";
    private static final String COLLECTION_ID = "collectionId";
    private static final String ELEMENT_COPY_FROM = "elementCopyFrom";
    private static final String OBJECT_ID = "objectId";
    private static final String OBJECT_ATTR_ID = "objectAttrId";
    private static final String OBJECT_ATTR_CODE = "objectAttrCode";
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();
    private final VersionJdbcDao versionDao;

    public DomainCacheJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor, VersionJdbcDao versionDao) {
        super(dataSource, connectionInterceptor);
        this.versionDao = versionDao;
        this.setDefaultFetchSize(50);
    }

    public Date getLastUpdate() {
        LOGGER.trace("enter getLastUpdate()");
        return this.jdbcTemplate().queryForObject(this.dialect.parse("select max(lastupdate) from @DOMAINELEMENT"), Date.class);
    }

    public Date getRegionVersionLastUpdate() {
        LOGGER.trace("enter getRegionVersionLastUpdate()");
        return this.jdbcTemplate().queryForObject(this.dialect.parse("select max(lastupdate) from @REGIONVERSION"), Date.class);
    }

    public Date getDomainDefinitionLastUpdate() {
        LOGGER.trace("enter getDomainDefinitionLastUpdate()");
        Date typesDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse("select max(modifiedDate) from @DOMAINTYPE"), Date.class));
        Date collectionDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse("select max(modifiedDate) from @DOMAINTYPECOLLECTION"), Date.class));
        Date attributeDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse("select max(modifiedDate) from @DOMAINTYPEATTRIBUTE"), Date.class));
        Date tmpMax = typesDate.getTime() > collectionDate.getTime() ? typesDate : collectionDate;
        return tmpMax.getTime() > attributeDate.getTime() ? tmpMax : attributeDate;
    }

    public Map<String, HyperonDomainObjectTypeImpl> getTypesByCode(String profileCode) {
        LOGGER.trace("enter getTypesById({})", (Object)profileCode);
        HashMap<String, HyperonDomainObjectTypeImpl> result = new HashMap<String, HyperonDomainObjectTypeImpl>();
        final HashMap resultByTypeId = new HashMap();
        StringBuilder query = new StringBuilder("select dtc.id as id, dtc.$code as collectionCode, dtc.$name as collectionName, dt.typeNature as typeNature, dtc.type_id as typeId, dt.$code as typeCode, dt.$name as typeName, dtc.collectionType_Id as collectionType, dtc.multiple as multiple, dtc.visible as visible, dtc.collorder as collOrder, dtParent.rootType as rootCollection, dtParent.code as parentTypeCode, dt.typeNature as typeNature");
        query.append(" from @DOMAINTYPECOLLECTION dtc");
        query.append(" join @domainType dt on dt.id=dtc.collectionType_id");
        query.append(" join @domainType dtParent on dtParent.id=dtc.type_id");
        query.append(" where dt.profile_code=?");
        query.append(" and dtc.archive=0");
        query.append(" and dt.archive=0");
        query.append(" and dtParent.archive=0");
        String sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, (rs, i) -> {
            HyperonDomainObjectTypeImpl type = new HyperonDomainObjectTypeImpl(rs.getInt("id"), this.dialect.getString(rs, COLLECTION_CODE), this.dialect.getString(rs, "collectionName"));
            type.setCollectionType(rs.getInt("collectionType"));
            type.setTypeId(rs.getInt("typeId"));
            type.setTypeCode(rs.getString("typeCode"));
            type.setTypeName(rs.getString("typeName"));
            type.setMultiple(rs.getBoolean("multiple"));
            type.setVisible(rs.getBoolean("visible"));
            type.setRootCollection(rs.getBoolean("rootCollection"));
            type.setParentTypeCode(rs.getString("parentTypeCode"));
            type.setTypeNature(rs.getString("typeNature"));
            type.setOrder(rs.getInt("collOrder"));
            result.put(Integer.toString(type.getId()), type);
            this.updateResultByTypeId(resultByTypeId, type);
            return null;
        }, profileCode);
        for (Map.Entry collections : result.entrySet()) {
            HyperonDomainObjectTypeImpl collection = (HyperonDomainObjectTypeImpl)collections.getValue();
            for (Map.Entry childCollections : result.entrySet()) {
                HyperonDomainObjectTypeImpl child = (HyperonDomainObjectTypeImpl)childCollections.getValue();
                if (!child.getTypeId().equals(collection.getCollectionType())) continue;
                collection.addChildrenTypes(child);
                child.addParentTypes(collection);
            }
        }
        query = new StringBuilder("select dta.$type_id as typeId, dta.$attrtype as attrType, dta.$code as attrCode,");
        query.append(" dta.$name as name, dta.$groupname as groupName, dta.groupOrder as groupOrder, dta.$defaultreftype as defaultType, dta.$defaultrefname as defaultValue, dta.id as attrId, dta.attrorder as attrOrder");
        query.append(" from @DOMAINTYPEATTRIBUTE dta");
        query.append(" inner join @domainType dt on dt.id=dta.type_id and dt.archive=0");
        query.append(" where dt.profile_code=?");
        query.append(" and dta.archive=0");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new RowMapper<Object>(){

            @Override
            public Object mapRow(ResultSet rs, int i) throws SQLException {
                Integer typeId = DomainCacheJdbcDao.this.dialect.getInt(rs, "typeId");
                HyperonAttributeDefinitionImpl attrType = new HyperonAttributeDefinitionImpl(DomainCacheJdbcDao.this.dialect.getString(rs, "attrType"), DomainCacheJdbcDao.this.dialect.getString(rs, "attrCode"), DomainCacheJdbcDao.this.dialect.getString(rs, "name"), DomainCacheJdbcDao.this.dialect.getString(rs, "groupName"));
                String defaultType = DomainCacheJdbcDao.this.dialect.getString(rs, "defaultType");
                if (StringUtils.isNotBlank((CharSequence)defaultType)) {
                    attrType.setDefaultType(MpDomainAttributeDto.RawType.valueOf(defaultType));
                    attrType.setDefaultValue(rs.getString("defaultValue"));
                }
                attrType.setId(rs.getInt("attrId"));
                attrType.setOrder(rs.getInt("attrOrder"));
                attrType.setGroupOrder(rs.getInt("groupOrder"));
                List collection = (List)resultByTypeId.get(Integer.toString(typeId));
                if (collection != null) {
                    for (HyperonDomainObjectTypeImpl coll : collection) {
                        coll.addAttributeDefinition(attrType);
                    }
                }
                return null;
            }
        }, profileCode);
        return result;
    }

    public Integer getTypeById(int elementId) {
        LOGGER.trace("enter getTypeById({})", (Object)elementId);
        String query = "select d.collection_id from @DOMAINELEMENT d where d.id =" + elementId;
        String sql = this.dialect.parse(query);
        return this.jdbcTemplate().queryForObject(sql, Integer.class);
    }

    private void updateResultByTypeId(Map<String, List<HyperonDomainObjectTypeImpl>> resultByTypeId, HyperonDomainObjectTypeImpl type) {
        List<HyperonDomainObjectTypeImpl> collectionsList = resultByTypeId.get(Integer.toString(type.getCollectionType()));
        if (collectionsList == null) {
            collectionsList = new ArrayList<HyperonDomainObjectTypeImpl>();
        }
        collectionsList.add(type);
        resultByTypeId.put(Integer.toString(type.getCollectionType()), collectionsList);
    }

    public Map<String, HyperonDomainObjectImpl> getObjectsById(String profileCode, int sessionId, Map<String, HyperonDomainObjectTypeImpl> types, Set<Integer> userRegionVersions) {
        LOGGER.trace("enter getObjectsById({})", (Object)profileCode);
        StringBuilder query = new StringBuilder("select d.id as objectId, d.$code as objectCode, d.$name as objectName, d.parent_id as objectParentId");
        query.append(", d.collection_id as collectionId, rv.versionNumber as regionVersion, r.code as regionCode, d.regionVersion_id as versionId");
        query.append(" ,d.$copyfromid as elementCopyFrom, d.$worksessionid as elementWorksessionId, d.head as head");
        query.append(" from @DOMAINELEMENT d");
        query.append(" left join @regionVersion  rv on rv.id=d.regionVersion_id");
        query.append(" left join @region  r on r.id=rv.region_id");
        query.append(" where d.profile_code=?");
        if (sessionId == -1) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition(" and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        HashMap<String, HyperonDomainObjectImpl> result = new HashMap<String, HyperonDomainObjectImpl>();
        this.jdbcTemplate().query(sql, (rs, i) -> {
            int collectionId = this.dialect.getInt(rs, COLLECTION_ID);
            HyperonDomainObjectTypeImpl type = (HyperonDomainObjectTypeImpl)types.get(Integer.toString(collectionId));
            HyperonDomainObjectImpl object = new HyperonDomainObjectImpl(rs.getInt(OBJECT_ID), this.dialect.getString(rs, "objectCode"), this.dialect.getString(rs, "objectName"), type, this.getInteger(rs.getObject("objectParentId")), rs.getBoolean("head"));
            int elementSessionId = rs.getInt("elementWorksessionId");
            int copyFrom = rs.getInt(ELEMENT_COPY_FROM);
            object.setIdToSelectChildren(this.getCorrectParentId(object.getId(), copyFrom, elementSessionId, sessionId));
            object.setCopyFrom(copyFrom);
            object.setSessionId(elementSessionId);
            object.setRegion(this.getMpRegion(rs));
            result.put(object.getId() + "", object);
            return null;
        }, profileCode);
        return result;
    }

    public Map<String, Integer> getNewParents(String profileCode, Set<Integer> userRegionVersions) {
        LOGGER.trace("enter getNewParents");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        StringBuilder query = new StringBuilder("select d.id as objectId, d.$copyfromid as elementCopyFrom");
        query.append(" from @DOMAINELEMENT d");
        query.append(" left join @regionVersion  rv on rv.id=d.regionVersion_id");
        query.append(" left join @region  r on r.id=rv.region_id");
        query.append(" where d.profile_code=?");
        query.append(" and d.head=1");
        query.append(" and d.archive=0");
        query.append(" and d.$copyfromid > 0");
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            int objectId = rs.getInt(OBJECT_ID);
            int copyFrom = rs.getInt(ELEMENT_COPY_FROM);
            result.put(Integer.toString(copyFrom), objectId);
            return null;
        }, profileCode);
        return result;
    }

    public HyperonDomainObjectImpl getObjectById(int elementId, String path, HyperonDomainObjectTypeImpl type, AttributeValueProvider valueProvider, Set<Integer> regionIds) {
        LOGGER.trace("enter getObjectById({}, {})", (Object)elementId, (Object)type);
        StringBuilder query = new StringBuilder("select d.id as objectId, d.$code as objectCode, d.$name as objectName, d.parent_id as objectParentId");
        query.append(", d.collection_id as collectionId, rv.versionNumber as regionVersion, r.code as regionCode, d.regionVersion_id as versionId");
        query.append(" ,d.$copyfromid as elementCopyFrom, d.$worksessionid as elementWorksessionId, d.head as head");
        query.append(" from @DOMAINELEMENT d");
        query.append(" left join @regionVersion  rv on rv.id=d.regionVersion_id");
        query.append(" left join @region  r on r.id=rv.region_id");
        query.append(" where d.id=?");
        this.addRegionsCondition(regionIds, query);
        String sql = this.dialect.parse(query.toString());
        ArrayList tmp = new ArrayList();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            HyperonDomainObjectImpl object = new HyperonDomainObjectImpl(rs.getInt(OBJECT_ID), this.dialect.getString(rs, "objectCode"), this.dialect.getString(rs, "objectName"), type, this.getInteger(rs.getObject("objectParentId")), rs.getBoolean("head"));
            int elementSessionId = rs.getInt("elementWorksessionId");
            int copyFrom = rs.getInt(ELEMENT_COPY_FROM);
            object.setIdToSelectChildren(this.getCorrectParentId(object.getId(), copyFrom, elementSessionId, elementSessionId));
            object.setCopyFrom(copyFrom);
            object.setSessionId(elementSessionId);
            object.setRegion(this.getMpRegion(rs));
            tmp.add(object);
            return null;
        }, elementId);
        if (tmp.isEmpty()) {
            return null;
        }
        HyperonDomainObjectImpl result = (HyperonDomainObjectImpl)tmp.get(0);
        result.setPath(path);
        query = new StringBuilder("select deea.id as objectAttrId, deea.$code as objectAttrCode, deea.$name as objectAttrName, deea.attrType as objectAttrType, deea.attrValue as objectAttrValue, deea.refType as objectRefType, deea.domainElement_Id as objectId");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" inner join @domainElementExtraAttr  deea on deea.domainElement_id=d.id");
        query.append(" where d.id=?");
        sql = this.dialect.parse(query.toString());
        ArrayList attrTmp = new ArrayList();
        long dynamicAttrsStartTime = System.currentTimeMillis();
        this.jdbcTemplate().query(sql, (rs, i) -> {
            MpDomainAttributeDto attribute = new MpDomainAttributeDto(rs.getInt(OBJECT_ATTR_ID), rs.getInt(OBJECT_ID), this.dialect.getString(rs, OBJECT_ATTR_CODE));
            attribute.setName(this.dialect.getString(rs, "objectAttrName"));
            attribute.setType(this.dialect.getString(rs, "objectAttrType"));
            attribute.setRawValue(this.dialect.getString(rs, "objectAttrValue"));
            String objectRefType = this.dialect.getString(rs, "objectRefType");
            attribute.setRawType(objectRefType == null ? MpDomainAttributeDto.RawType.LITERAL : MpDomainAttributeDto.RawType.valueOf(objectRefType));
            attribute.getDomainObjectId();
            attrTmp.add(new HyperonDomainAttribute(attribute, result, valueProvider));
            AttributeEngineProfiler.DOMAIN.addLoadMeasure(new AttributeKey(path, attribute.getCode()), dynamicAttrsStartTime, System.currentTimeMillis());
            return null;
        }, elementId);
        result.setDynamicAttributes(new ArrayList<HyperonDomainAttribute>(attrTmp));
        query = new StringBuilder("select dea.id as objectAttrId, dta.$code as objectAttrCode, dta.$name as objectAttrDesc, dea.refname as objectAttrRefName, dea.refType as objectAttrRefType, dea.TYPEATTRIBUTE_ID as typeId, dea.domainElement_id as objectId");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" inner join @domainElementAttribute  dea on dea.domainElement_Id=d.id");
        query.append(" inner join @domainTypeAttribute  dta on dta.id=dea.TYPEATTRIBUTE_ID  and dta.archive=0");
        query.append(" where d.id=?");
        sql = this.dialect.parse(query.toString());
        attrTmp.clear();
        long attrsStartTime = System.currentTimeMillis();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            int idTmp = rs.getInt(OBJECT_ID);
            MpDomainAttributeDto attribute = new MpDomainAttributeDto(rs.getInt(OBJECT_ATTR_ID), idTmp, this.dialect.getString(rs, OBJECT_ATTR_CODE));
            attribute.setName(this.dialect.getString(rs, "objectAttrDesc"));
            attribute.setRawValue(this.dialect.getString(rs, "objectAttrRefName"));
            attribute.setRawType(MpDomainAttributeDto.RawType.valueOf(this.dialect.getString(rs, "objectAttrRefType")));
            attrTmp.add(new HyperonDomainAttribute(attribute, result, valueProvider));
            AttributeEngineProfiler.DOMAIN.addLoadMeasure(new AttributeKey(path, attribute.getCode()), attrsStartTime, System.currentTimeMillis());
            return null;
        }, elementId);
        result.setAttributes(new ArrayList<HyperonDomainAttribute>(attrTmp));
        return result;
    }

    protected void addRegionsCondition(Set<Integer> userRegionVersions, StringBuilder query) {
        if (userRegionVersions.isEmpty()) {
            query.append(" and d.regionversion_id is null");
        } else {
            String userVersionsIds = this.getIdsToIn(userRegionVersions);
            query.append(" and (d.regionversion_id in (");
            query.append(userVersionsIds);
            query.append(" )");
            query.append(" or d.regionversion_id is null)");
        }
    }

    private String getIdsToIn(Set<Integer> userRegionVersions) {
        StringBuilder result = new StringBuilder();
        for (Integer ver : userRegionVersions) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(ver);
        }
        return result.toString();
    }

    private Integer getCorrectParentId(int objectId, int copyFrom, int objectSessionId, int sessionId) {
        if (objectSessionId == sessionId && copyFrom > 0) {
            return copyFrom;
        }
        return objectId;
    }

    private String sessionCondition(String andOrWhere, int sessionId) {
        StringBuilder where = new StringBuilder(" ");
        where.append(andOrWhere);
        where.append(" d.archive = 0 and ");
        where.append("((d.head = 0");
        where.append(" and d.workSessionId = ").append(sessionId).append(")");
        where.append(" or (d.head = 1 ").append(" and not exists (select de2.id from @domainElement de2 where de2.copyFromId=d.id and de2.workSessionId=").append(sessionId).append(") ) )");
        return where.toString();
    }

    public Map<String, List<MpReferenceDto>> getReferences(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        LOGGER.trace("enter getReferences({})", (Object)profileCode);
        StringBuilder query = new StringBuilder("select dr.parent_id as parentId, dr.$elementPath as path, dr.collection_id as collectionId, dtc.code as collectionCode");
        query.append(" from @DOMAINELEMENT d");
        query.append(" join @domainReference  dr on dr.parent_id=d.id");
        query.append(" join @domainTypeCollection  dtc on dtc.id=dr.collection_id");
        query.append(" where d.profile_code=?");
        query.append(" and dtc.archive=0");
        if (sessionId == -1) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition(" and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        HashMap<String, List<MpReferenceDto>> result = new HashMap<String, List<MpReferenceDto>>();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            int parentId = this.dialect.getInt(rs, "parentId");
            ArrayList<MpReferenceDto> paths = (ArrayList<MpReferenceDto>)result.get(Integer.toString(parentId));
            if (paths == null) {
                paths = new ArrayList<MpReferenceDto>();
            }
            paths.add(new MpReferenceDto(this.dialect.getString(rs, "path"), this.dialect.getInt(rs, COLLECTION_ID), this.dialect.getString(rs, COLLECTION_CODE)));
            result.put(Integer.toString(parentId), paths);
            return null;
        }, profileCode);
        return result;
    }

    public List<MpReferenceDto> getReferences(int elementId) {
        LOGGER.trace("enter getReferences({})", (Object)elementId);
        StringBuilder query = new StringBuilder("select dr.parent_id as parentId, dr.$elementPath as path, dr.collection_id as collectionId, dtc.code as collectionCode");
        query.append(" from @DOMAINELEMENT d");
        query.append(" join @domainReference  dr on dr.parent_id=d.id");
        query.append(" join @domainTypeCollection  dtc on dtc.id=dr.collection_id");
        query.append(" where d.id=?");
        String sql = this.dialect.parse(query.toString());
        ArrayList<MpReferenceDto> result = new ArrayList<MpReferenceDto>();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            this.dialect.getInt(rs, "parentId");
            result.add(new MpReferenceDto(this.dialect.getString(rs, "path"), this.dialect.getInt(rs, COLLECTION_ID), this.dialect.getString(rs, COLLECTION_CODE)));
            return null;
        }, elementId);
        return result;
    }

    public Map<String, Date> getProfileLastUpdates() {
        LOGGER.trace("enter getProfileLastUpdates()");
        HashMap<String, Date> result = new HashMap<String, Date>();
        StringBuilder query = new StringBuilder("select d.profile_code as profile, max(d.lastupdate) as lastupdate");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" group by d.profile_code");
        String sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, (rs, i) -> {
            Date date = new Date(this.dialect.getTimestamp(rs, "lastupdate").getTime());
            result.put(this.dialect.getString(rs, "profile"), date);
            return null;
        });
        query = new StringBuilder("select d.profile_code as profile, max(d.modifieddate) as lastupdate");
        query.append(" from @DOMAINTYPE  d");
        query.append(" group by d.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        query = new StringBuilder("select dt.profile_code as profile, max(dtc.modifieddate) as lastupdate");
        query.append(" from @DOMAINTYPECOLLECTION  dtc");
        query.append(" inner join @domainType dt on dt.id = dtc.type_id");
        query.append(" group by dt.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        query = new StringBuilder("select dt.profile_code as profile, max(dta.modifieddate) as lastupdate");
        query.append(" from @DOMAINTYPEATTRIBUTE  dta");
        query.append(" inner join @domainType dt on dt.id = dta.type_id");
        query.append(" group by dt.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        query = new StringBuilder("select r.profile_code as profile, max(rv.lastupdate) as lastupdate");
        query.append(" from @regionversion rv");
        query.append(" inner join @region r on r.id = rv.region_id");
        query.append(" group by r.profile_code");
        sql = this.dialect.parse(query.toString());
        this.jdbcTemplate().query(sql, new MaxDateRowMapper(result));
        return result;
    }

    public Map<String, List<DomainAttributeLoadWrapper>> getObjectsDynamicAttributesByObjectId(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        LOGGER.trace("enter getObjectsDynamicAttributesByObjectId({})", (Object)profileCode);
        StringBuilder query = new StringBuilder("select deea.id as objectAttrId, deea.$code as objectAttrCode, deea.$name as objectAttrName, deea.attrType as objectAttrType, deea.attrValue as objectAttrValue, deea.refType as objectRefType, deea.domainElement_Id as objectId");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" inner join @domainElementExtraAttr  deea on deea.domainElement_id=d.id");
        query.append(" where d.profile_code=?");
        if (sessionId == -1) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition("and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        HashMap<String, List<DomainAttributeLoadWrapper>> result = new HashMap<String, List<DomainAttributeLoadWrapper>>();
        long start = System.currentTimeMillis();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            MpDomainAttributeDto attribute = new MpDomainAttributeDto(rs.getInt(OBJECT_ATTR_ID), rs.getInt(OBJECT_ID), this.dialect.getString(rs, OBJECT_ATTR_CODE));
            attribute.setName(this.dialect.getString(rs, "objectAttrName"));
            attribute.setType(this.dialect.getString(rs, "objectAttrType"));
            attribute.setRawValue(this.dialect.getString(rs, "objectAttrValue"));
            String objectRefType = this.dialect.getString(rs, "objectRefType");
            attribute.setRawType(objectRefType == null ? MpDomainAttributeDto.RawType.LITERAL : MpDomainAttributeDto.RawType.valueOf(objectRefType));
            String id = attribute.getDomainObjectId() + "";
            result.put(id, this.addToList(result, attribute, id, start, System.currentTimeMillis()));
            return null;
        }, profileCode);
        return result;
    }

    public Map<String, List<DomainAttributeLoadWrapper>> getObjectsAttributesByObjectId(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        LOGGER.trace("enter getObjectsAttributesByObjectId({})", (Object)profileCode);
        StringBuilder query = new StringBuilder("select dea.id as objectAttrId, dta.$code as objectAttrCode, dta.$name as objectAttrDesc, dea.refname as objectAttrRefName, dea.refType as objectAttrRefType, dea.TYPEATTRIBUTE_ID as typeId, dea.domainElement_id as objectId");
        query.append(" from @DOMAINELEMENT  d");
        query.append(" inner join @domainElementAttribute  dea on dea.domainElement_Id=d.id");
        query.append(" inner join @domainTypeAttribute  dta on dta.id=dea.TYPEATTRIBUTE_ID  and dta.archive=0");
        query.append(" where d.profile_code=?");
        if (sessionId == -1) {
            query.append(" and d.head=1");
            query.append(" and d.archive=0");
        } else {
            query.append(this.sessionCondition("and", sessionId));
        }
        this.addRegionsCondition(userRegionVersions, query);
        String sql = this.dialect.parse(query.toString());
        HashMap<String, List<DomainAttributeLoadWrapper>> result = new HashMap<String, List<DomainAttributeLoadWrapper>>();
        long start = System.currentTimeMillis();
        this.jdbcTemplate(100).query(sql, (rs, i) -> {
            int idTmp = rs.getInt(OBJECT_ID);
            MpDomainAttributeDto attribute = new MpDomainAttributeDto(rs.getInt(OBJECT_ATTR_ID), idTmp, this.dialect.getString(rs, OBJECT_ATTR_CODE));
            attribute.setName(this.dialect.getString(rs, "objectAttrDesc"));
            attribute.setRawValue(this.dialect.getString(rs, "objectAttrRefName"));
            attribute.setRawType(MpDomainAttributeDto.RawType.valueOf(this.dialect.getString(rs, "objectAttrRefType")));
            result.put(Integer.toString(idTmp), this.addToList(result, attribute, Integer.toString(idTmp), start, System.currentTimeMillis()));
            return null;
        }, profileCode);
        return result;
    }

    private Integer getInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public List<MpVersion> getUserVersions(String profileCode, String user) {
        return this.versionDao.getUserRegionVersions(profileCode, user);
    }

    public List<MpOpenSession> getOpenSessions(String profile, String user) {
        LOGGER.trace("enter getOpenSessions({},{})", (Object)profile, (Object)user);
        String sql = this.dialect.parse(" select ws.id as id from @worksession  ws  where ws.status = ?   and ws.username = ?   and ws.remotesession = 0");
        ArrayList<MpOpenSession> result = new ArrayList<MpOpenSession>();
        try {
            Integer sid = this.jdbcTemplate().queryForObject(sql, Integer.class, "OPEN", user);
            if (sid != null) {
                sql = this.dialect.parse("select max(d.id) as id from @DOMAINELEMENT d  where d.worksessionid = ?   and d.profile_code = ?   and d.head = 0");
                Integer elId = this.jdbcTemplate().queryForObject(sql, Integer.class, sid, profile);
                if (elId != null) {
                    result.add(new MpOpenSession(sid, user));
                }
            }
        }
        catch (EmptyResultDaoException e) {
            LOGGER.trace("no open session");
        }
        return result;
    }

    public Date getLastUpdateForProfile(String profileCode) {
        LOGGER.trace("enter getLastUpdateForProfile({})", (Object)profileCode);
        return this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse("select max(lastupdate) from @DOMAINELEMENT where profile_code=? and head=1"), Date.class, profileCode));
    }

    public Date getLastUpdateForOpenSession(String profileCode, String user) {
        LOGGER.trace("enter getLastUpdateForOpenSession({},{})", (Object)profileCode, (Object)user);
        String query = " select max(lastupdate) from @DOMAINELEMENT where profile_code = ?    and worksessionid in (select id from @worksession where $username=? and status = 'OPEN') ";
        String sql = this.dialect.parse(query);
        return this.normalizeDate(this.jdbcTemplate().queryForObject(sql, Date.class, profileCode, user));
    }

    public Date getDefinitionLastUpdateInProfile(String profileCode) {
        Date typesDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse("select max(modifiedDate) from @DOMAINTYPE where profile_code=?"), Date.class, profileCode));
        Date collectionDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse(" select max(dtc.modifiedDate) from @DOMAINTYPECOLLECTION dtc where dtc.type_id in (select dt.id from @DOMAINTYPE dt where dt.profile_code=?)"), Date.class, profileCode));
        Date attributeDate = this.normalizeDate(this.jdbcTemplate().queryForObject(this.dialect.parse(" select max(dta.modifiedDate) from @DOMAINTYPEATTRIBUTE dta join @DOMAINTYPE dt on dt.id=dta.type_id where dt.profile_code=?"), Date.class, profileCode));
        Date tmpMax = typesDate.getTime() > collectionDate.getTime() ? typesDate : collectionDate;
        tmpMax = tmpMax.getTime() > attributeDate.getTime() ? tmpMax : attributeDate;
        return tmpMax;
    }

    private Date normalizeDate(Date date) {
        return date != null ? date : DATE_1900;
    }

    private MpRegionCached getMpRegion(ResultSet rs) throws SQLException {
        String regionCode = this.dialect.getString(rs, "regionCode");
        MpRegionCached region = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{regionCode}) ? new MpRegionCached(regionCode, this.dialect.getString(rs, "regionVersion"), this.dialect.getInt(rs, "versionId")) : new MpRegionCached();
        return region;
    }

    private List<DomainAttributeLoadWrapper> addToList(Map<String, List<DomainAttributeLoadWrapper>> result, MpDomainAttributeDto attribute, String id, long loadStartTime, long loadEndTime) {
        List<DomainAttributeLoadWrapper> attrList = result.get(id);
        if (attrList == null) {
            attrList = new ArrayList<DomainAttributeLoadWrapper>();
        }
        attrList.add(new DomainAttributeLoadWrapper(attribute, new LoadTime(loadStartTime, loadEndTime)));
        return attrList;
    }

    public SortedSet<Integer> getSystemVersionWithoutMy(String profile, SortedSet<Integer> myVersions) {
        return this.versionDao.getSystemVersions(profile, myVersions);
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        cal.set(1900, 0, 1, 0, 0, 0);
        DATE_1900 = cal.getTime();
    }

    public static class DomainAttributeLoadWrapper {
        private final MpDomainAttributeDto dto;
        private final LoadTime loadTime;

        DomainAttributeLoadWrapper(MpDomainAttributeDto dto, LoadTime loadTime) {
            this.dto = dto;
            this.loadTime = loadTime;
        }

        public MpDomainAttributeDto getDto() {
            return this.dto;
        }

        public LoadTime getLoadTime() {
            return this.loadTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomainAttributeLoadWrapper that = (DomainAttributeLoadWrapper)o;
            return Objects.equals(this.dto, that.dto) && Objects.equals(this.loadTime, that.loadTime);
        }

        public int hashCode() {
            return Objects.hash(this.dto, this.loadTime);
        }
    }

    private final class MaxDateRowMapper
    implements RowMapper<Object> {
        private final Map<String, Date> result;

        private MaxDateRowMapper(Map<String, Date> result) {
            this.result = result;
        }

        @Override
        public Object mapRow(ResultSet rs, int i) throws SQLException {
            Date date = new Date(DomainCacheJdbcDao.this.dialect.getTimestamp(rs, "lastupdate").getTime());
            String profile = DomainCacheJdbcDao.this.dialect.getString(rs, "profile");
            Date current = this.result.get(profile);
            if (current != null && date.after(current)) {
                this.result.put(profile, date);
            }
            return null;
        }
    }
}

