/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import java.time.LocalDateTime;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.domain.AbstractDomainCacheManager;
import pl.decerto.hyperon.runtime.core.domain.MpDomainCacheProvider;
import pl.decerto.hyperon.runtime.core.domain.MpDomainRefreshController;
import pl.decerto.hyperon.runtime.core.domain.SessionIdBuilder;
import pl.decerto.hyperon.runtime.core.domain.WatcherDomainCacheManager;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionResolver;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.MpTreeDomain;

public class MpDomainCacheManager
extends AbstractDomainCacheManager
implements WatcherDomainCacheManager {
    private static final Logger log = LoggerFactory.getLogger(MpDomainCacheManager.class);
    private final EffectiveVersionResolver effectiveVersionResolver;
    private Map<CacheKey, TreeDomainWrapper> headRegionVersionElementsByProfiles = new ConcurrentHashMap<CacheKey, TreeDomainWrapper>();

    public MpDomainCacheManager(MpDomainCacheProvider cacheProvider, EffectiveVersionResolver effectiveVersionResolver, MpDomainRefreshController refreshController) {
        super(cacheProvider, refreshController);
        this.effectiveVersionResolver = effectiveVersionResolver;
    }

    @Override
    public Set<String> getProfiles() {
        TreeSet<String> profiles = new TreeSet<String>(super.getProfilesFromHead());
        profiles.addAll(this.getProfilesFromRegionVersionCache());
        log.trace("getProfiles() found: {}", profiles);
        return profiles;
    }

    private Set<String> getProfilesFromRegionVersionCache() {
        return this.headRegionVersionElementsByProfiles.keySet().stream().map(CacheKey::getProfile).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getAllProfiles() {
        Set<String> allProfiles = super.getHeadAndSessionProfiles();
        allProfiles.addAll(this.getProfilesFromRegionVersionCache());
        log.trace("getAllProfiles() found: {}", allProfiles);
        return allProfiles;
    }

    @Override
    public HyperonDomainObject getByPath(String profileCode, String path, EffectiveVersionConfiguration configuration) {
        TreeDomainWrapper treeDomainWrapper;
        log.trace("enter getByPath({}, {}, {})", new Object[]{profileCode, path, configuration});
        Set<Integer> currentVersionsWithinProfile = this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration);
        CacheKey cacheKey = new CacheKey(profileCode, currentVersionsWithinProfile);
        if (this.headElementsByProfiles.get(profileCode) == null && this.headRegionVersionElementsByProfiles.get(cacheKey) == null) {
            this.refreshController.updateTimestampsForProfile(profileCode);
            this.refreshHeadsOfProfile(profileCode, configuration);
        }
        if ((treeDomainWrapper = this.headRegionVersionElementsByProfiles.get(cacheKey)) != null) {
            log.debug("returning domain from region version cache, key:{}", (Object)cacheKey);
            treeDomainWrapper.updateLastFetchTime();
            return treeDomainWrapper.getTreeDomain().getObjectsByPath(path);
        }
        if (this.headElementsByProfiles.get(profileCode) == null) {
            return null;
        }
        return ((MpTreeDomain)this.headElementsByProfiles.get(profileCode)).getObjectsByPath(path);
    }

    @Override
    protected void refreshHeadsOfProfile(String profileCode, EffectiveVersionConfiguration configuration) {
        MpTreeDomain treeDomain = this.cacheProvider.createTreeOfObjects(profileCode, configuration);
        Set<Integer> currentVersionsWithinProfile = this.effectiveVersionResolver.getEffectiveVersionIds(profileCode, configuration);
        CacheKey cacheKey = new CacheKey(profileCode, currentVersionsWithinProfile);
        if (treeDomain.isAnyRoot()) {
            if (currentVersionsWithinProfile.isEmpty()) {
                log.debug("put domain tree to headElementsByProfiles cache for {}", (Object)profileCode);
                this.headElementsByProfiles.put(profileCode, treeDomain);
            } else {
                log.debug("put domain tree to headRegionVersionElementsByProfiles cache for: {}", (Object)cacheKey);
                this.headRegionVersionElementsByProfiles.put(cacheKey, new TreeDomainWrapper(treeDomain));
            }
        } else {
            log.debug("try removing tree by profileCode and versions {}", (Object)cacheKey);
            boolean wasRemoved = this.headRegionVersionElementsByProfiles.entrySet().removeIf(pair -> Objects.equals(cacheKey, pair.getKey()));
            if (!wasRemoved) {
                log.debug("remove domain trees by profile {}, because cache key couldn't be matched", (Object)profileCode);
                this.headRegionVersionElementsByProfiles.entrySet().removeIf(pair -> Objects.equals(profileCode, ((CacheKey)pair.getKey()).getProfile()));
            }
            this.headElementsByProfiles.remove(profileCode);
        }
    }

    @Override
    public HyperonDomainObject getSessionElementByPath(String profileCode, String user, String path, EffectiveVersionConfiguration configuration) {
        log.trace("enter getSessionElementByPath(profile={},user={}, path={}, configuration:{})", new Object[]{profileCode, user, path, configuration});
        String cacheKey = SessionIdBuilder.getId(user, profileCode);
        if (this.sessionElementsByProfiles.get(cacheKey) == null) {
            this.refreshSessionsOfProfileAndUser(profileCode, user, configuration);
            if (this.sessionElementsByProfiles.get(cacheKey) == null) {
                return null;
            }
        }
        return ((MpTreeDomain)this.sessionElementsByProfiles.get(cacheKey)).getObjectsByPath(path);
    }

    @Override
    public void refreshProfile(String profileCode) {
        long start = System.currentTimeMillis();
        log.info("enter refreshProfile({})", (Object)profileCode);
        this.refreshHeadsOfProfile(profileCode);
        this.refreshSessionsOfProfile(profileCode);
        log.info("refreshProfile {}  finished in {} msek", (Object)profileCode, (Object)(System.currentTimeMillis() - start));
    }

    private void refreshSessionsOfProfile(String profileCode) {
        log.trace("enter refreshSessionsOfProfile({})", (Object)profileCode);
        if (this.sessionElementsByProfiles.isEmpty()) {
            return;
        }
        for (String userProfile : this.sessionElementsByProfiles.keySet()) {
            if (!userProfile.endsWith("@" + profileCode)) continue;
            String user = StringUtils.substringBefore((String)userProfile, (String)"@");
            this.refreshSessionsOfProfileAndUser(profileCode, user, null);
        }
    }

    @Override
    public boolean wasSomethingChange() {
        return this.refreshController.wasSomethingChange(this.getAllProfiles());
    }

    @Override
    public Map<String, Date> getLastUpdatesByProfile() {
        return this.refreshController.getLastUpdatesByProfile();
    }

    @Override
    public Set<String> getPossibleModification(Map<String, Date> lastUpdatesByProfile) {
        return this.refreshController.getPossibleModification(lastUpdatesByProfile, this.getAllProfiles());
    }

    @Override
    public void updateProfileController(String profile, Map<String, Date> lastUpdatesByProfile) {
        this.refreshController.updateTimestampByProfile(lastUpdatesByProfile, profile);
    }

    @Override
    public void doWatch() {
        if (this.wasSomethingChange()) {
            Map<String, Date> lastUpdatesByProfile = this.getLastUpdatesByProfile();
            for (String profile : this.getPossibleModification(lastUpdatesByProfile)) {
                this.refreshProfile(profile);
                this.updateProfileController(profile, lastUpdatesByProfile);
            }
        }
    }

    @Override
    public void invalidateTreeVersionCachesAfter(int invalidateValue, TemporalUnit unit) {
        LocalDateTime currentTime = LocalDateTime.now();
        log.trace("before invalidate headRegionVersionElementsByProfiles cache size: {}", (Object)this.headRegionVersionElementsByProfiles.size());
        this.headRegionVersionElementsByProfiles.entrySet().removeIf(entry -> this.canRemoveEntry(invalidateValue, unit, currentTime, (Map.Entry<CacheKey, TreeDomainWrapper>)entry));
        log.trace("after invalidate headRegionVersionElementsByProfiles cache size: {}", (Object)this.headRegionVersionElementsByProfiles.size());
    }

    private boolean canRemoveEntry(int invalidateValue, TemporalUnit unit, LocalDateTime currentTime, Map.Entry<CacheKey, TreeDomainWrapper> entry) {
        LocalDateTime treeLifespan = entry.getValue().getLastFetchTime().plus(invalidateValue, unit);
        return treeLifespan.isBefore(currentTime);
    }

    class TreeDomainWrapper {
        private final MpTreeDomain treeDomain;
        private LocalDateTime lastFetchTime;

        TreeDomainWrapper(MpTreeDomain treeDomain) {
            this.treeDomain = treeDomain;
            this.lastFetchTime = LocalDateTime.now();
        }

        MpTreeDomain getTreeDomain() {
            return this.treeDomain;
        }

        LocalDateTime getLastFetchTime() {
            return this.lastFetchTime;
        }

        void updateLastFetchTime() {
            this.lastFetchTime = LocalDateTime.now();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TreeDomainWrapper)) {
                return false;
            }
            TreeDomainWrapper that = (TreeDomainWrapper)o;
            return Objects.equals(this.treeDomain, that.treeDomain) && Objects.equals(this.lastFetchTime, that.lastFetchTime);
        }

        public int hashCode() {
            return Objects.hash(this.treeDomain, this.lastFetchTime);
        }
    }

    class CacheKey {
        private final String profile;
        private final Set<Integer> versionIds;

        CacheKey(String profile, Set<Integer> versionIds) {
            this.profile = profile;
            this.versionIds = versionIds;
        }

        String getProfile() {
            return this.profile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.profile, cacheKey.profile) && Objects.equals(this.versionIds, cacheKey.versionIds);
        }

        public int hashCode() {
            return Objects.hash(this.profile, this.versionIds);
        }

        public String toString() {
            return new StringJoiner(", ", CacheKey.class.getSimpleName() + "[", "]").add("profile='" + this.profile + "'").add("versionIds=" + this.versionIds).toString();
        }
    }
}

