/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.samples;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import pl.decerto.hyperon.mp.simulation.samples.RangeBasedSamplesException;
import pl.decerto.hyperon.mp.simulation.samples.Samples;
import pl.decerto.hyperon.mp.simulation.samples.iterator.BigDecimalRangeIterator;
import pl.decerto.hyperon.mp.simulation.samples.iterator.DateRangeIterator;
import pl.decerto.hyperon.mp.simulation.samples.iterator.IntegerRangeIterator;
import pl.decerto.hyperon.runtime.utils.Messages;

public class RangeBasedSamples<V>
implements Samples<V> {
    private V min;
    private V max;
    private BigDecimal step;
    private Class<V> type;
    private String stepType;

    public RangeBasedSamples(Class<V> type, V min, V max, BigDecimal step) {
        this.type = type;
        this.min = min;
        this.max = max;
        this.step = step;
    }

    public RangeBasedSamples(Class<V> type, V min, V max, BigDecimal step, String stepType) {
        this(type, min, max, step);
        this.stepType = stepType;
    }

    @Override
    public Iterator<V> iterator() {
        if (BigDecimal.class.equals(this.type)) {
            return new BigDecimalRangeIterator(this);
        }
        if (Integer.class.equals(this.type)) {
            return new IntegerRangeIterator(this);
        }
        if (Date.class.equals(this.type)) {
            return new DateRangeIterator(this, this.stepType == null ? "" : this.stepType);
        }
        throw new RangeBasedSamplesException(Messages.message("simulation.samples.input.series.error"));
    }

    public V getMin() {
        return this.min;
    }

    public V getMax() {
        return this.max;
    }

    public BigDecimal getStep() {
        return this.step;
    }

    public Class<V> getType() {
        return this.type;
    }
}

