/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.charge;

import java.math.BigDecimal;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;

public class UnitChargeToDebtCollector {
    public void collectChargeToDeptForFund(SimulationLifeContext context) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        ChargeDefinition chargeDefinition = context.getCurrentChargeDefinition();
        InvestPolicyValueSimulationContext.Fund fund = context.getCurrentFund();
        ChargeValueDefinition chargeValue = ChargeValueDefinition.getChargeValueDefinition(context);
        if (SimulationMathematicalFunctions.greaterThanZero(chargeValue.getValue()) && SimulationMathematicalFunctions.greaterThanZero(fund.getUnitPrice())) {
            BigDecimal chargeAmount = chargeValue.calculateAmount(account.calculateCurrentAccountCapital());
            BigDecimal fundChargeAmount = this.calculateFundChargeAmount(context, chargeAmount);
            BigDecimal fundChargeInUnits = SimulationMathematicalFunctions.divide(fundChargeAmount, fund.getUnitPrice());
            account.addChargeToDebt(new InvestPolicyValueSimulationContext.FundCharge(fund.getFundDefinition(), fundChargeInUnits, chargeDefinition, chargeValue));
        }
    }

    private BigDecimal calculateFundChargeAmount(SimulationLifeContext context, BigDecimal chargeAmount) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        InvestPolicyValueSimulationContext.Fund fund = context.getCurrentFund();
        BigDecimal capital = account.calculateCurrentAccountCapital();
        BigDecimal fundShareOfCapital = SimulationMathematicalFunctions.greaterThanZero(capital) ? SimulationMathematicalFunctions.divide(fund.getCapital(), capital) : BigDecimal.ZERO;
        return SimulationMathematicalFunctions.multiply(chargeAmount, fundShareOfCapital);
    }
}

