/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.api;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.SimulationMpEngineProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

public class ChargeValueDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChargeValueDefinition.class);
    public static final ChargeValueDefinition ZERO_VALUE = new ChargeValueDefinition(BigDecimal.ZERO, null);
    private BigDecimal value;
    private Type type;

    public ChargeValueDefinition(BigDecimal value, Type type) {
        this.value = value;
        this.type = type;
    }

    public ChargeValueDefinition(String type, BigDecimal value) {
        this.value = value;
        this.type = Type.valueOf(type);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal calculateAmount(BigDecimal referenceValue) {
        if (this == ZERO_VALUE) {
            return BigDecimal.ZERO;
        }
        if (this.getType() == Type.PERCENT) {
            return SimulationMathematicalFunctions.multiply(referenceValue, SimulationMathematicalFunctions.divide(this.getValue(), SimulationMathematicalFunctions.ONE_HUNDRED));
        }
        if (this.getType() == Type.RATE) {
            return SimulationMathematicalFunctions.multiply(referenceValue, this.getValue());
        }
        return this.getValue();
    }

    public static ChargeValueDefinition getChargeValueDefinition(SimulationLifeContext context) {
        LOGGER.trace("getChargeValueDefinition based on parameter {}", (Object)context.getChargeValueParameter());
        return ChargeValueDefinition.getChargeDefinition(context, context.getChargeValueParameter());
    }

    public static ChargeValueDefinition getChargeValueDefinition(SimulationLifeContext context, String parameterName) {
        return ChargeValueDefinition.getChargeDefinition(context, parameterName);
    }

    private static ChargeValueDefinition getChargeDefinition(SimulationLifeContext context, String paramName) {
        HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId());
        try {
            ParamValue pv = mpEngine.get(paramName, context);
            return pv == null || pv.size() == 0 ? ZERO_VALUE : new ChargeValueDefinition(pv.getBigDecimal("charge.value"), pv.getEnum("charge.valueType", Type.class));
        }
        catch (ParameterValueNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return ZERO_VALUE;
        }
    }

    public static enum Type {
        PERCENT,
        AMOUNT,
        RATE;

    }
}

