/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.matchers;

import org.smartparam.engine.matchers.InvalidBetweenMatcherPatternException;
import org.smartparam.engine.matchers.RangeToken;
import org.smartparam.engine.util.EngineUtil;

public class BetweenMatcherTokenSeparator {
    private static final char[] DEFAULT_SEPARATORS = new char[]{':', '-', ','};
    private char[] separators = DEFAULT_SEPARATORS;

    public RangeToken separate(String pattern) {
        char separator = this.findSeparator(pattern);
        String[] tokens = EngineUtil.split2(pattern, separator);
        if (tokens.length != 2) {
            throw new InvalidBetweenMatcherPatternException("could not split " + pattern + " pattern to 2 tokens");
        }
        String lower = tokens[0].trim();
        String upper = tokens[1].trim();
        return new RangeToken(lower, upper, separator);
    }

    private char findSeparator(String pattern) {
        for (char ch : this.separators) {
            if (pattern.indexOf(ch) < 0) continue;
            return ch;
        }
        return DEFAULT_SEPARATORS[0];
    }

    public final void setSeparators(String separators) {
        if (separators != null) {
            this.separators = separators.toCharArray();
        }
    }
}

