/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.matchers;

import org.smartparam.engine.annotated.annotations.ObjectInstance;
import org.smartparam.engine.annotated.annotations.ParamMatcher;
import org.smartparam.engine.core.matcher.Matcher;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.matchers.BetweenMatcherTokenSeparator;
import org.smartparam.engine.matchers.RangeToken;
import pl.decerto.hyperon.runtime.helper.HyperonLevelConstants;

@ParamMatcher(value="", instances={@ObjectInstance(value="between/ie", constructorArgs={"true", "false"}), @ObjectInstance(value="between/ei", constructorArgs={"false", "true"}), @ObjectInstance(value="between/ii", constructorArgs={"true", "true"}), @ObjectInstance(value="between/ee", constructorArgs={"false", "false"})})
public class BetweenMatcher
implements Matcher {
    private boolean lowerInclusive = true;
    private boolean upperInclusive = false;
    private BetweenMatcherTokenSeparator tokenSeparator = new BetweenMatcherTokenSeparator();

    public BetweenMatcher() {
    }

    public BetweenMatcher(String lowerInclusive, String upperInclusive) {
        this.setLowerInclusive(Boolean.parseBoolean(lowerInclusive));
        this.setUpperInclusive(Boolean.parseBoolean(upperInclusive));
    }

    public BetweenMatcher(String lowerInclusive, String upperInclusive, String separators) {
        this(Boolean.parseBoolean(lowerInclusive), Boolean.parseBoolean(upperInclusive), separators);
    }

    public BetweenMatcher(boolean lowerInclusive, boolean upperInclusive, String separators) {
        this.setLowerInclusive(lowerInclusive);
        this.setUpperInclusive(upperInclusive);
        this.setSeparators(separators);
    }

    @Override
    public <T extends ValueHolder> boolean matches(String value, String pattern, Type<T> type) {
        RangeToken rangeToken = this.tokenSeparator.separate(pattern);
        T v = type.decode(value);
        return this.lowerCondition(v, rangeToken.getLower(), type) && this.upperCondition(v, rangeToken.getUpper(), type);
    }

    private <T extends ValueHolder> boolean lowerCondition(T v, String lower, Type<T> type) {
        return this.checkCondition(v, lower, type, false);
    }

    private <T extends ValueHolder> boolean upperCondition(T v, String upper, Type<T> type) {
        return this.checkCondition(v, upper, type, true);
    }

    private <T extends ValueHolder> boolean checkCondition(T v, String boundary, Type<T> type, boolean upper) {
        if (HyperonLevelConstants.ASTERISK.getValue().equals(boundary) || "".equals(boundary)) {
            return true;
        }
        T u = type.decode(boundary);
        if (upper) {
            return this.upperInclusive ? v.compareTo(u) <= 0 : v.compareTo(u) < 0;
        }
        return this.lowerInclusive ? u.compareTo(v) <= 0 : u.compareTo(v) < 0;
    }

    public final void setLowerInclusive(boolean lowerInclusive) {
        this.lowerInclusive = lowerInclusive;
    }

    public final void setUpperInclusive(boolean upperInclusive) {
        this.upperInclusive = upperInclusive;
    }

    public final void setSeparators(String separators) {
        this.tokenSeparator.setSeparators(separators);
    }
}

