/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.function;

import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionInvocationException;
import org.smartparam.engine.core.function.FunctionInvoker;
import org.smartparam.engine.core.function.FunctionManager;
import org.smartparam.engine.core.function.FunctionProvider;
import org.smartparam.engine.core.function.InvokerRepository;
import org.smartparam.engine.core.function.UnknownFunctionInvokerException;

public class BasicFunctionManager
implements FunctionManager {
    private final InvokerRepository invokerRepository;
    private final FunctionProvider functionProvider;

    public BasicFunctionManager(InvokerRepository invokerRepository, FunctionProvider functionProvider) {
        this.invokerRepository = invokerRepository;
        this.functionProvider = functionProvider;
    }

    @Override
    public Object invokeFunction(String name, Object ... args) {
        Function function = this.functionProvider.getFunction(name);
        return this.invokeFunction(function, args);
    }

    @Override
    public Object invokeFunction(Function function, Object ... args) {
        FunctionInvoker invoker = this.invokerRepository.getInvoker(function);
        if (invoker == null) {
            throw new UnknownFunctionInvokerException(function);
        }
        try {
            return invoker.invoke(function, args);
        }
        catch (RuntimeException e) {
            throw new FunctionInvocationException(e, function);
        }
    }
}

