/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smartparam.engine.annotated.RepositoryObjectKey;
import org.smartparam.engine.annotated.repository.ScanningFunctionProvider;
import org.smartparam.engine.annotated.repository.ScanningInvokerRepository;
import org.smartparam.engine.annotated.repository.ScanningMatcherRepository;
import org.smartparam.engine.annotated.repository.ScanningTypeRepository;
import org.smartparam.engine.cache.MapFunctionCache;
import org.smartparam.engine.cache.MapPreparedParamCache;
import org.smartparam.engine.config.initialization.ComponentInitializer;
import org.smartparam.engine.config.initialization.ComponentInitializerRunner;
import org.smartparam.engine.config.pico.ComponentConfig;
import org.smartparam.engine.core.function.BasicFunctionManager;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.function.FunctionInvoker;
import org.smartparam.engine.core.function.FunctionRepository;
import org.smartparam.engine.core.matcher.Matcher;
import org.smartparam.engine.core.parameter.BasicParameterProvider;
import org.smartparam.engine.core.parameter.ParamRepository;
import org.smartparam.engine.core.prepared.BasicLevelPreparer;
import org.smartparam.engine.core.prepared.BasicParamPreparer;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import org.smartparam.engine.core.type.Type;

public class ParamEngineConfig
extends ComponentConfig {
    private final List<ParamRepository> parameterRepositories = new ArrayList<ParamRepository>();
    private final Map<RepositoryObjectKey, FunctionRepository> functionRepositories = new HashMap<RepositoryObjectKey, FunctionRepository>();
    private final Map<String, FunctionInvoker> functionInvokers = new HashMap<String, FunctionInvoker>();
    private final Map<String, Type<?>> types = new HashMap();
    private final Map<String, Matcher> matchers = new HashMap<String, Matcher>();
    private PreparedParamCache parameterCache;
    private FunctionCache functionCache;
    private ComponentInitializerRunner initializationRunner;
    private final List<ComponentInitializer> componentInitializers = new ArrayList<ComponentInitializer>();

    @Override
    protected void injectDefaults(List<Object> components) {
        components.add(BasicParamPreparer.class);
        components.add(BasicLevelPreparer.class);
        components.add(MapPreparedParamCache.class);
        components.add(BasicFunctionManager.class);
        components.add(ScanningFunctionProvider.class);
        components.add(MapFunctionCache.class);
        components.add(ScanningInvokerRepository.class);
        components.add(BasicParameterProvider.class);
        components.add(ScanningTypeRepository.class);
        components.add(ScanningMatcherRepository.class);
    }

    public List<ParamRepository> getParameterRepositories() {
        return Collections.unmodifiableList(this.parameterRepositories);
    }

    protected void addParameterRepositories(List<ParamRepository> parameterRepositories) {
        this.parameterRepositories.addAll(parameterRepositories);
    }

    public Map<RepositoryObjectKey, FunctionRepository> getFunctionRepositories() {
        return Collections.unmodifiableMap(this.functionRepositories);
    }

    protected void addFunctionRepository(RepositoryObjectKey key, FunctionRepository functionRepository) {
        this.functionRepositories.put(key, functionRepository);
    }

    public Map<String, FunctionInvoker> getFunctionInvokers() {
        return Collections.unmodifiableMap(this.functionInvokers);
    }

    protected void addFunctionInvoker(String key, FunctionInvoker functionInvoker) {
        this.functionInvokers.put(key, functionInvoker);
    }

    public Map<String, Type<?>> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    protected void addType(String key, Type<?> type) {
        this.types.put(key, type);
    }

    public Map<String, Matcher> getMatchers() {
        return Collections.unmodifiableMap(this.matchers);
    }

    protected void addMatcher(String key, Matcher matcher) {
        this.matchers.put(key, matcher);
    }

    public FunctionCache getFunctionCache() {
        return this.functionCache;
    }

    protected void setFunctionCache(FunctionCache functionCache) {
        this.functionCache = functionCache;
        this.addComponent(functionCache);
    }

    public PreparedParamCache getParameterCache() {
        return this.parameterCache;
    }

    protected void setParameterCache(PreparedParamCache parameterCache) {
        this.parameterCache = parameterCache;
        this.addComponent(parameterCache);
    }

    public List<ComponentInitializer> getComponentInitializers() {
        return Collections.unmodifiableList(this.componentInitializers);
    }

    protected void addComponentInitializers(List<ComponentInitializer> componentInitializers) {
        this.componentInitializers.addAll(componentInitializers);
    }

    public ComponentInitializerRunner getInitializationRunner() {
        return this.initializationRunner;
    }

    public void setInitializationRunner(ComponentInitializerRunner initializationRunner) {
        this.initializationRunner = initializationRunner;
    }
}

