/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.smartparam.engine.core.prepared.CacheEntry;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import org.smartparam.engine.core.prepared.PreparedParameter;
import pl.decerto.hyperon.runtime.core.versioninterceptor.VersionInterceptor;
import pl.decerto.hyperon.runtime.exception.HyperonIllegalStateException;
import pl.decerto.hyperon.runtime.model.MpParameter;
import pl.decerto.hyperon.runtime.provider.MpParameterProvider;
import pl.decerto.hyperon.runtime.sync.RuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.Trackable;
import pl.decerto.hyperon.runtime.sync.event.ElementType;

public class ParamRuntimeWatcher
extends RuntimeWatcher {
    private final MpParameterProvider provider;
    private final VersionInterceptor versionInterceptor;
    private final PreparedParamCache indexCache;

    public ParamRuntimeWatcher(MpParameterProvider provider, PreparedParamCache indexCache, VersionInterceptor versionInterceptor) {
        this.provider = provider;
        this.indexCache = indexCache;
        this.versionInterceptor = versionInterceptor;
    }

    @Override
    protected String getWatcherName() {
        return "param-watcher";
    }

    @Override
    public Date getLastUpdate() {
        return this.provider.getLastUpdate();
    }

    @Override
    public List<Trackable> getAllLastUpdates() {
        return this.provider.getAllLastUpdates();
    }

    @Override
    public List<Trackable> getAllCached() {
        List<CacheEntry<PreparedParameter>> all = this.indexCache.list();
        ArrayList<Trackable> result = new ArrayList<Trackable>(all.size());
        for (CacheEntry<PreparedParameter> entry : all) {
            String key = entry.getKey();
            this.getMetadata(entry.getValue()).map(metadata -> new Trackable(metadata.getId(), key, metadata.getLastUpdate())).ifPresent(result::add);
        }
        return result;
    }

    @Override
    boolean isChanged(Trackable cached, Trackable fresh) {
        return super.isChanged(cached, fresh) || this.isMasterChanged(cached);
    }

    private boolean isMasterChanged(Trackable cached) {
        return this.getCachedParameter(cached).map(cachedParam -> cachedParam.isSlave() && this.isMasterUpdatedAfterSlaveLoad((MpParameter)cachedParam)).orElse(true);
    }

    private Optional<MpParameter> getCachedParameter(Trackable cached) {
        return this.getMetadata(this.indexCache.get(cached.getCode()));
    }

    private boolean isMasterUpdatedAfterSlaveLoad(MpParameter slaveParameter) {
        return this.isMasterUpdatedAfterSlaveLoad(this.getMasterParameter(slaveParameter), slaveParameter);
    }

    private MpParameter getMasterParameter(MpParameter slaveParameter) {
        String masterUid = this.versionInterceptor.decorateParameterUid(slaveParameter.getMasterName());
        PreparedParameter masterFromCache = this.indexCache.get(masterUid);
        return Objects.isNull(masterFromCache) ? (MpParameter)this.provider.load(masterUid).getMetadata() : this.getMetadata(masterFromCache).orElseThrow(() -> new HyperonIllegalStateException("metadata cannot be null from not null prepared parameter"));
    }

    private boolean isMasterUpdatedAfterSlaveLoad(MpParameter masterParameter, MpParameter slaveParameter) {
        boolean masterUpdatedAfterSlaveLoad;
        boolean bl = masterUpdatedAfterSlaveLoad = !masterParameter.getLastUpdate().before(slaveParameter.getLoadedAt());
        if (masterUpdatedAfterSlaveLoad) {
            this.log.debug("cached slave parameter:{} must be invalidated, its master:{} was updated after slave load time", (Object)slaveParameter, (Object)masterParameter);
        }
        return masterUpdatedAfterSlaveLoad;
    }

    private Optional<MpParameter> getMetadata(PreparedParameter masterParameter) {
        return Optional.ofNullable(masterParameter).map(mp -> (MpParameter)mp.getMetadata());
    }

    @Override
    public void invalidate(int id) {
        this.indexCache.invalidate(id);
    }

    @Override
    public ElementType getElementType() {
        return ElementType.PARAMETER;
    }
}

