/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sql.dialect;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.sql.HyperonDialect;

public abstract class DefaultDialect
implements HyperonDialect {
    private static final String EMPTY_STRING = "";
    private final Map<String, String> columnAliases = this.map(new String[0]);
    private final Map<String, String> tableAliases = this.map(new String[0]);
    private final Map<String, String> hints = this.map(new String[0]);

    public DefaultDialect withColumnAliases(String ... elements) {
        this.columnAliases.putAll(this.map(elements));
        return this;
    }

    public DefaultDialect withTableAliases(String ... elements) {
        this.tableAliases.putAll(this.map(elements));
        return this;
    }

    public DefaultDialect withHint(String ... elements) {
        this.hints.putAll(this.map(elements));
        return this;
    }

    @Override
    public String column(String column) {
        return this.columnAliases.getOrDefault(this.normalizeIdentifier(column), column);
    }

    @Override
    public String table(String table) {
        return this.tableAliases.getOrDefault(this.normalizeIdentifier(table), table);
    }

    @Override
    public String selectFromSequence(String sequence) {
        return this.selectFromSequence(sequence, null);
    }

    @Override
    public String hint(String token) {
        return this.hints.getOrDefault(this.normalizeIdentifier(token), EMPTY_STRING);
    }

    public String normalizeIdentifier(String identifier) {
        return identifier.toLowerCase();
    }

    protected Map<String, String> map(String ... args) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (args == null || args.length % 2 == 1) {
            throw new HyperonRuntimeException("Illegal number of elements passed to method");
        }
        for (int i = 0; i < args.length; i += 2) {
            String key = this.normalizeIdentifier(args[i]);
            String value = args[i + 1];
            map.put(key, value);
        }
        return map;
    }

    public Map<String, String> getColumnAliases() {
        return Collections.unmodifiableMap(this.columnAliases);
    }

    public Map<String, String> getTableAliases() {
        return Collections.unmodifiableMap(this.tableAliases);
    }

    protected String concatenateSchema(String schema, String str) {
        return StringUtils.isEmpty((CharSequence)schema) ? str : schema + "." + str;
    }
}

