/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.provider;

import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.function.FunctionRepository;
import pl.decerto.hyperon.runtime.dao.FunctionJdbcDao;
import pl.decerto.hyperon.runtime.helper.uid.Uid;
import pl.decerto.hyperon.runtime.helper.uid.UidParser;
import pl.decerto.hyperon.runtime.model.MpFunction;
import pl.decerto.hyperon.runtime.profiler.engine.EngineProfiler;
import pl.decerto.hyperon.runtime.sync.Trackable;

public class MpFunctionProvider
implements FunctionRepository {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FunctionJdbcDao dao;
    private final EngineProfiler profiler = EngineProfiler.FUNCTION;

    public MpFunctionProvider(FunctionJdbcDao dao) {
        this.dao = dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MpFunction loadFunction(String uid) {
        long t = System.currentTimeMillis();
        try {
            MpFunction mpFunction = this.load(uid);
            return mpFunction;
        }
        finally {
            this.profiler.addLoadMeasure(uid, t, System.currentTimeMillis());
        }
    }

    private MpFunction load(String uid) {
        this.log.debug("loading function, uid={}", (Object)uid);
        Uid spec = UidParser.parseUid(uid);
        return this.dao.getFunction(spec.getCode(), spec.getVersion(), spec.getSid());
    }

    public Date getLastUpdate() {
        return this.dao.getMaxLastUpdate();
    }

    public List<Trackable> getAllLastUpdates() {
        return this.dao.getAllLastUpdates();
    }
}

