/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.prefetch;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.runtime.prefetch.ParamInitializer;

class ParamPrefetcherRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ParamPrefetcherRunnable.class);
    private static final int DEFAULT_PAUSE_AFTER_FAILURE_SECONDS = 10;
    private final List<String> toPrefetch;
    private final ParamInitializer initializer;
    private final int pauseAfterFailure;

    ParamPrefetcherRunnable(List<String> toPrefetch, ParamInitializer initializer) {
        this(toPrefetch, initializer, 10);
    }

    ParamPrefetcherRunnable(List<String> toPrefetch, ParamInitializer initializer, int pauseAfterFailure) {
        this.toPrefetch = toPrefetch;
        this.initializer = initializer;
        this.pauseAfterFailure = pauseAfterFailure;
    }

    @Override
    public void run() {
        log.debug("starting asynchronous param initializer...");
        if (log.isDebugEnabled()) {
            log.debug(Printer.print(this.toPrefetch, "params to be prefetched"));
        }
        long t = System.currentTimeMillis();
        int i = 0;
        for (String code : this.toPrefetch) {
            log.debug("initializing {}/{} - {}", new Object[]{++i, this.toPrefetch.size(), code});
            try {
                this.initializer.initialize(code);
            }
            catch (RuntimeException e) {
                log.error("failed to initialize parameter", (Throwable)e);
                this.pauseAfterFailure();
            }
        }
        log.debug("finished param initialization, time={} ms", (Object)(System.currentTimeMillis() - t));
    }

    private void pauseAfterFailure() {
        this.pause(this.pauseAfterFailure);
    }

    private void pause(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException e) {
            log.warn("pause interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

