/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.Date;
import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.helper.StrUtil;
import pl.decerto.hyperon.runtime.model.MpFunction;

public class MpGroovyFunction
extends MpFunction {
    private static final String[] EMPTY_ARGS = new String[0];
    private String args;
    private String body;
    private String[] argsArray = EMPTY_ARGS;
    private final String virtualName;

    public MpGroovyFunction(int id, int implId, String code, String args, String body, Date lastupdate) {
        super(id, implId, code, "groovy", lastupdate);
        this.withArgs(args);
        this.withBody(body);
        this.virtualName = this.createVirtualName();
    }

    public MpGroovyFunction(int id, int implId, String code, String args, String body) {
        this(id, implId, code, args, body, null);
    }

    public MpGroovyFunction(String code) {
        super(0, 0, code, "groovy", null);
        this.virtualName = this.createVirtualName();
    }

    public MpGroovyFunction withArgs(String args) {
        this.args = args;
        this.createArgsArray();
        return this;
    }

    public MpGroovyFunction withBody(String body) {
        this.body = body;
        return this;
    }

    public String getArgs() {
        return this.args;
    }

    public String getBody() {
        return this.body;
    }

    private void createArgsArray() {
        if (StrUtil.isEmpty(this.args)) {
            this.argsArray = EMPTY_ARGS;
        } else {
            this.argsArray = EngineUtil.split(this.args, ',');
            for (int i = 0; i < this.argsArray.length; ++i) {
                this.argsArray[i] = this.argsArray[i].trim();
            }
        }
    }

    public String[] getArgsArray() {
        return this.argsArray;
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    private String createVirtualName() {
        StringBuilder sb = new StringBuilder(this.getName().length() + 30);
        sb.append("g_");
        sb.append(this.getId()).append('_');
        sb.append(this.getImplId()).append('_');
        String code = this.getName();
        for (int i = 0; i < code.length(); ++i) {
            char c = code.charAt(i);
            sb.append(this.escape(c));
        }
        return sb.toString();
    }

    private char escape(char c) {
        return (char)(Character.isLetter((char)c) || Character.isDigit((char)c) ? c : 95);
    }
}

