/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.model.HyperonAttributeDefinition;
import pl.decerto.hyperon.runtime.model.HyperonAttributeDefinitionImpl;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;

public class HyperonDomainObjectTypeImpl
implements HyperonDomainObjectType {
    private final Integer id;
    private final String code;
    private final String name;
    private List<HyperonDomainObjectType> parentTypes = new ArrayList<HyperonDomainObjectType>();
    private List<HyperonDomainObjectType> childrenTypes = new ArrayList<HyperonDomainObjectType>();
    private List<HyperonAttributeDefinition> attributeDefinitions = new ArrayList<HyperonAttributeDefinition>();
    private Map<String, HyperonAttributeDefinition> attributeDefinitionMap = new HashMap<String, HyperonAttributeDefinition>();
    private Integer collectionType;
    private Integer typeId;
    private String typeCode;
    private String typeName;
    private boolean multiple;
    private boolean visible;
    private boolean rootCollection;
    private String parentTypeCode;
    private String typeNature;
    private int order;
    Comparator<HyperonDomainObjectType> comparator = new CollectionComparator();
    Comparator<HyperonAttributeDefinition> attrComparator = new AttrComparator();

    public HyperonDomainObjectTypeImpl(int id, String code, String name) {
        this.id = id;
        this.code = code;
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<HyperonDomainObjectType> getParentTypes() {
        ArrayList<HyperonDomainObjectType> copy = new ArrayList<HyperonDomainObjectType>(this.parentTypes);
        Collections.sort(copy, this.comparator);
        return copy;
    }

    public void addParentTypes(HyperonDomainObjectTypeImpl parentType) {
        this.parentTypes.add(parentType);
    }

    @Override
    public List<HyperonDomainObjectType> getChildrenTypes() {
        ArrayList<HyperonDomainObjectType> copy = new ArrayList<HyperonDomainObjectType>(this.childrenTypes);
        Collections.sort(copy, this.comparator);
        return copy;
    }

    public void addChildrenTypes(HyperonDomainObjectTypeImpl childrenType) {
        this.childrenTypes.add(childrenType);
    }

    @Override
    public List<HyperonAttributeDefinition> getAttributeDefinitions() {
        ArrayList<HyperonAttributeDefinition> copy = new ArrayList<HyperonAttributeDefinition>(this.attributeDefinitions);
        Collections.sort(copy, this.attrComparator);
        return copy;
    }

    @Override
    public HyperonAttributeDefinition getAttributeDefinition(String code) {
        return this.attributeDefinitionMap.get(code);
    }

    public void addAttributeDefinition(HyperonAttributeDefinition attrDefinition) {
        this.attributeDefinitions.add(attrDefinition);
        this.attributeDefinitionMap.put(attrDefinition.getCode(), attrDefinition);
    }

    @Override
    public Integer getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Integer collectionType) {
        this.collectionType = collectionType;
    }

    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isRootCollection() {
        return this.rootCollection;
    }

    public void setRootCollection(boolean rootCollection) {
        this.rootCollection = rootCollection;
    }

    public String getParentTypeCode() {
        return this.parentTypeCode;
    }

    public void setParentTypeCode(String parentTypeCode) {
        this.parentTypeCode = parentTypeCode;
    }

    public String getTypeNature() {
        return this.typeNature;
    }

    public void setTypeNature(String typeNature) {
        this.typeNature = typeNature;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getFullCode() {
        return this.parentTypeCode + "[" + this.code + "]";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MppDomainObjectTypeDto [id=");
        builder.append(this.id);
        builder.append(", code=");
        builder.append(this.code);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HyperonDomainObjectTypeImpl other = (HyperonDomainObjectTypeImpl)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    final class AttrComparator
    implements Comparator<HyperonAttributeDefinition> {
        AttrComparator() {
        }

        @Override
        public int compare(HyperonAttributeDefinition o1, HyperonAttributeDefinition o2) {
            int groupCompare = StringUtils.trimToEmpty((String)o2.getGroupName()).compareTo(StringUtils.trimToEmpty((String)o1.getGroupName()));
            if (groupCompare == 0) {
                return Integer.valueOf(((HyperonAttributeDefinitionImpl)o1).getOrder()).compareTo(((HyperonAttributeDefinitionImpl)o2).getOrder());
            }
            return groupCompare;
        }
    }

    private final class CollectionComparator
    implements Comparator<HyperonDomainObjectType> {
        private CollectionComparator() {
        }

        @Override
        public int compare(HyperonDomainObjectType o1, HyperonDomainObjectType o2) {
            return Integer.valueOf(((HyperonDomainObjectTypeImpl)o1).getOrder()).compareTo(((HyperonDomainObjectTypeImpl)o2).getOrder());
        }
    }
}

