/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.license;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDetailsDto;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDto;
import pl.decerto.hyperon.runtime.license.LicenseSignatureService;
import pl.decerto.hyperon.runtime.security.DefaultKey;
import pl.decerto.hyperon.runtime.security.KeyProvider;
import pl.decerto.hyperon.runtime.utils.hash.DigestAlgorithm;
import pl.decerto.hyperon.runtime.utils.hash.HashUtils;

public class LicenseSignatureServiceImpl
implements LicenseSignatureService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseSignatureService.class);
    private final Signature signature = this.createSignature();

    @Override
    public boolean verify(HyperonLicenseDto license) {
        return this.verify(license, DefaultKey.PUBLIC.getResourcePath());
    }

    @Override
    public boolean verify(HyperonLicenseDto license, String publicKeyPath) {
        if (license == null) {
            throw new IllegalArgumentException("cannot verify null license");
        }
        PublicKey publicKey = this.getPublicKey(publicKeyPath);
        if (publicKey == null) {
            throw new IllegalArgumentException("could not create public key from given path:" + publicKeyPath);
        }
        return this.verify(license, publicKey);
    }

    @Override
    public boolean verify(HyperonLicenseDto license, URL publicKeyUrl) {
        if (license == null) {
            throw new IllegalArgumentException("cannot verify null license");
        }
        PublicKey publicKey = this.getPublicKey(publicKeyUrl);
        if (publicKey == null) {
            throw new IllegalArgumentException("could not create public key from given URL: " + publicKeyUrl);
        }
        return this.verify(license, publicKey);
    }

    @Override
    public byte[] sign(HyperonLicenseDetailsDto licenseDetails, String privateKeyPath) {
        if (licenseDetails == null) {
            throw new IllegalArgumentException("cannot create signature from null license details");
        }
        PrivateKey privateKey = this.getPrivateKey(privateKeyPath);
        if (privateKey == null) {
            throw new IllegalArgumentException("could not create private key from given path:" + privateKeyPath);
        }
        return this.sign(licenseDetails, privateKey);
    }

    @Override
    public byte[] sign(HyperonLicenseDetailsDto licenseDetails, URL privateKeyUrl) {
        if (licenseDetails == null) {
            throw new IllegalArgumentException("cannot create signature from null license details");
        }
        PrivateKey privateKey = this.getPrivateKey(privateKeyUrl);
        if (privateKey == null) {
            throw new IllegalArgumentException("could not create private key: " + privateKeyUrl);
        }
        return this.sign(licenseDetails, privateKey);
    }

    private boolean verify(HyperonLicenseDto license, PublicKey publicKey) {
        try {
            String objectHash = this.hash(license.getLicenseDetails().getDetailsAsKeyValueString());
            LOGGER.trace("hash for object {} is:{}", (Object)license, (Object)objectHash);
            this.signature.initVerify(publicKey);
            this.signature.update(objectHash.getBytes());
            return this.signature.verify(license.getSignature());
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new HyperonRuntimeException("signature error with publicKey: " + publicKey, e);
        }
    }

    private byte[] sign(HyperonLicenseDetailsDto licenseDetails, PrivateKey privateKey) {
        try {
            String objectHash = this.hash(licenseDetails.getDetailsAsKeyValueString());
            LOGGER.debug("hash for object {} is:{}", (Object)licenseDetails, (Object)objectHash);
            this.signature.initSign(privateKey);
            this.signature.update(objectHash.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = this.signature.sign();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("signature in base64:{}", (Object)DatatypeConverter.printBase64Binary((byte[])signatureBytes));
            }
            return signatureBytes;
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new HyperonRuntimeException("signature error with privateKey: " + privateKey, e);
        }
    }

    private Signature createSignature() {
        try {
            return Signature.getInstance("SHA256withRSA", "SunRsaSign");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new HyperonRuntimeException("could not create signature with SHA256withRSAalgorithm from provider SunRsaSign", e);
        }
    }

    private PrivateKey getPrivateKey(String path) {
        KeyProvider keyProvider = new KeyProvider();
        return keyProvider.getPrivateKey(path);
    }

    private PrivateKey getPrivateKey(URL url) {
        KeyProvider keyProvider = new KeyProvider();
        return keyProvider.getPrivateKey(url);
    }

    private PublicKey getPublicKey(String path) {
        KeyProvider keyProvider = new KeyProvider();
        return keyProvider.getPublicKey(path);
    }

    private PublicKey getPublicKey(URL url) {
        KeyProvider keyProvider = new KeyProvider();
        return keyProvider.getPublicKey(url);
    }

    private String hash(String objectAsString) {
        return HashUtils.hashText(DigestAlgorithm.MD5, objectAsString);
    }
}

