/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.license;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.smartparam.engine.types.date.SimpleDateFormatPool;

public class HyperonLicenseDetailsDto {
    public static final String STRING_SEPARATOR = ":";
    private Date validFrom;
    private Date validTo;
    private String licenseNumber;
    private String licensee;
    private Integer permittedCpuCores;
    private String specialConditions;

    private HyperonLicenseDetailsDto(Builder builder) {
        this.validFrom = builder.from;
        this.validTo = builder.to;
        this.licenseNumber = builder.licenseNumber;
        this.licensee = builder.licensee;
        this.permittedCpuCores = builder.permittedCpuCores;
        this.specialConditions = builder.specialConditions;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public Integer getPermittedCpuCores() {
        return this.permittedCpuCores;
    }

    public String getSpecialConditions() {
        return this.specialConditions;
    }

    public String getDetailsAsKeyValueString() {
        SimpleDateFormat dateFormat = SimpleDateFormatPool.get("yyyy-MM-dd");
        String details = "validFrom=" + dateFormat.format(this.validFrom) + STRING_SEPARATOR;
        details = details + "validTo=" + (this.validTo == null ? null : dateFormat.format(this.validTo)) + STRING_SEPARATOR;
        details = details + "licenseNumber=" + this.licenseNumber + STRING_SEPARATOR;
        details = details + "licensee=" + this.licensee + STRING_SEPARATOR;
        details = details + "permittedCpuCores=" + this.permittedCpuCores + STRING_SEPARATOR;
        details = details + "specialConditions=" + this.specialConditions;
        return details;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HyperonLicenseDetailsDto that = (HyperonLicenseDetailsDto)object;
        if (this.validFrom != null ? !this.validFrom.equals(that.validFrom) : that.validFrom != null) {
            return false;
        }
        if (this.validTo != null ? !this.validTo.equals(that.validTo) : that.validTo != null) {
            return false;
        }
        if (this.licenseNumber != null ? !this.licenseNumber.equals(that.licenseNumber) : that.licenseNumber != null) {
            return false;
        }
        if (this.licensee != null ? !this.licensee.equals(that.licensee) : that.licensee != null) {
            return false;
        }
        if (this.permittedCpuCores != null ? !this.permittedCpuCores.equals(that.permittedCpuCores) : that.permittedCpuCores != null) {
            return false;
        }
        return this.specialConditions != null ? this.specialConditions.equals(that.specialConditions) : that.specialConditions == null;
    }

    public int hashCode() {
        int result = this.validFrom != null ? this.validFrom.hashCode() : 0;
        result = 31 * result + (this.validTo != null ? this.validTo.hashCode() : 0);
        result = 31 * result + (this.licenseNumber != null ? this.licenseNumber.hashCode() : 0);
        result = 31 * result + (this.licensee != null ? this.licensee.hashCode() : 0);
        result = 31 * result + (this.permittedCpuCores != null ? this.permittedCpuCores.hashCode() : 0);
        result = 31 * result + (this.specialConditions != null ? this.specialConditions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HyperonLicenseDetailsDto{validFrom=" + this.validFrom + ", validTo=" + this.validTo + ", licenseNumber='" + this.licenseNumber + '\'' + ", licensee='" + this.licensee + '\'' + ", permittedCpuCores=" + this.permittedCpuCores + ", specialConditions='" + this.specialConditions + '\'' + '}';
    }

    public static class Builder {
        private Date from;
        private Date to;
        private String licenseNumber;
        private String licensee;
        private Integer permittedCpuCores;
        private String specialConditions;

        public Builder from(Date from) {
            this.from = from;
            return this;
        }

        public Builder to(Date to) {
            this.to = to;
            return this;
        }

        public Builder licenseNumber(String licenseNumber) {
            this.licenseNumber = licenseNumber;
            return this;
        }

        public Builder licensee(String licensee) {
            this.licensee = licensee;
            return this;
        }

        public Builder permittedCpuCores(Integer cores) {
            this.permittedCpuCores = cores;
            return this;
        }

        public Builder specialConditions(String specialConditions) {
            this.specialConditions = specialConditions;
            return this;
        }

        public HyperonLicenseDetailsDto build() {
            if (this.from == null) {
                throw new IllegalStateException("validFrom date cannot be null");
            }
            if (this.licenseNumber == null || this.licenseNumber.length() != 8) {
                throw new IllegalStateException("licenseNumber cannot be null and must contain 8 characters");
            }
            if (this.licensee == null) {
                throw new IllegalStateException("licensee cannot be null");
            }
            return new HyperonLicenseDetailsDto(this);
        }
    }
}

