/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.function.groovy.shell;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Script;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.function.groovy.shell.CompiledGroovyFunction;
import pl.decerto.hyperon.runtime.invoker.GroovyPreprocessor;

public class CachedGroovyShell
extends GroovyObjectSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedGroovyShell.class);
    private static final String DEFAULT_CODE_BASE = "/groovy/shell";
    private final Map<Integer, CompiledGroovyFunction> compileCache = new ConcurrentHashMap<Integer, CompiledGroovyFunction>();
    private Binding context;
    private GroovyClassLoader loader;
    private GroovyPreprocessor preprocessor = new GroovyPreprocessor();

    public CachedGroovyShell() {
        this.context = new Binding();
        final ClassLoader parentLoader = CachedGroovyShell.class.getClassLoader();
        this.loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new GroovyClassLoader(parentLoader, CompilerConfiguration.DEFAULT);
            }
        });
    }

    public Object evaluate(int implId, String fileName, String scriptText, Binding args) throws CompilationFailedException {
        LOGGER.trace("Evaluating groovy script: {} with args: {}", (Object)implId, (Object)args.getVariables());
        this.mergeWithContext(args);
        CompiledGroovyFunction compiled = this.getCompiled(implId, fileName, scriptText);
        Script script = InvokerHelper.createScript((Class)compiled.getCompiled(), (Binding)args);
        return script.run();
    }

    public List<? extends Message> validate(String scriptText) {
        LOGGER.debug("Validating groovy script");
        String scriptName = "validatedScript.groovy";
        GroovyCodeSource gcs = new GroovyCodeSource(scriptText, scriptName, DEFAULT_CODE_BASE);
        try {
            this.loader.parseClass(gcs, false);
        }
        catch (CompilationFailedException e) {
            LOGGER.warn("Groovy script validation error", (Throwable)e);
            if (e instanceof MultipleCompilationErrorsException) {
                return ((MultipleCompilationErrorsException)e).getErrorCollector().getErrors();
            }
            return Collections.singletonList(new ExceptionMessage((Exception)((Object)e), true, (ProcessingUnit)SourceUnit.create((String)scriptName, (String)scriptText)));
        }
        return Collections.emptyList();
    }

    private void mergeWithContext(Binding binding) {
        for (Object var : this.context.getVariables().keySet()) {
            if (binding.getVariables().containsKey(var)) continue;
            binding.setVariable((String)var, this.context.getVariable((String)var));
        }
    }

    private CompiledGroovyFunction getCompiled(int implId, String fileName, String scriptText) {
        CompiledGroovyFunction groovy = this.compileCache.get(implId);
        if (groovy == null) {
            LOGGER.debug("Groovy script: {} not found in cache, compiling", (Object)implId);
            groovy = this.compile(implId, fileName, this.preprocessor.preprocess(scriptText));
            this.compileCache.put(implId, groovy);
        }
        return groovy;
    }

    private CompiledGroovyFunction compile(int implId, String fileName, String scriptText) {
        GroovyCodeSource gcs = new GroovyCodeSource(scriptText, fileName, DEFAULT_CODE_BASE);
        Class compiled = this.compile(gcs);
        return new CompiledGroovyFunction(implId, fileName, gcs, compiled);
    }

    private Class compile(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.loader.parseClass(codeSource, false);
    }

    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    public Binding getContext() {
        return this.context;
    }

    public Map<Integer, CompiledGroovyFunction> compileCache() {
        return this.compileCache;
    }
}

