/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.decoder;

import org.smartparam.engine.core.decoder.ValueDecoder;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.decoder.MpCascadeDecoder;
import pl.decerto.hyperon.runtime.model.MpLevel;
import pl.decerto.hyperon.runtime.model.MpParameter;
import pl.decerto.hyperon.runtime.model.MpParameterEntry;

public class MpDecodingStrategy {
    private HyperonEngine engine;

    public MpDecodingStrategy() {
    }

    public MpDecodingStrategy(HyperonEngine engine) {
        this.engine = engine;
    }

    public ValueDecoder createCascadeDecoder() {
        return new MpCascadeDecoder(this.engine);
    }

    public void detectCascadingRefs(MpParameter p, MpParameterEntry entry) {
        int inputCnt = p.getInputLevels();
        int levelCnt = p.getLevelCount();
        String[] cells = entry.getLevels();
        for (int i = inputCnt; i < levelCnt; ++i) {
            MpLevel out = p.getLevel(i);
            if (out.getValueDecoder() != null || !this.hasRef(cells[i])) continue;
            out.setValueDecoder(this.createCascadeDecoder());
        }
    }

    private boolean hasRef(String cell) {
        if (cell != null && cell.length() > 3 && cell.indexOf(36) >= 0) {
            return (cell = cell.trim()).startsWith("$f ") || cell.startsWith("$p ");
        }
        return false;
    }

    public void setEngine(HyperonEngine engine) {
        this.engine = engine;
    }

    public boolean hasEngineConfigured() {
        return this.engine != null;
    }
}

