/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.BaseDao;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.model.MpSchedule;
import pl.decerto.hyperon.runtime.model.MpScheduleEntry;
import pl.decerto.hyperon.runtime.model.MpVersion;
import pl.decerto.hyperon.runtime.model.region.ScheduleContainer;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;

public class VersionJdbcDao
extends BaseDao {
    private static final Logger log = LoggerFactory.getLogger(VersionJdbcDao.class);
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();
    private static final int FETCH_SIZE = 100;

    public VersionJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
        this.setDefaultFetchSize(100);
    }

    public java.util.Date getMaxLastUpdate() {
        return this.jdbcTemplate().queryForObject(this.dialect.parse("select max(lastupdate) from @regionversion"), java.util.Date.class);
    }

    public Map<Integer, MpVersion> getAllRegionVersions() {
        String sql = this.dialect.parse(" select rv.id, rv.region_id, r.code, r.profile_code, rv.versionnumber, rv.active, rv.lastupdate from @regionversion rv inner join @region r on rv.region_id = r.id where rv.$archive = 0   and r.$archive = 0");
        List<MpVersion> list = this.jdbcTemplate().query(sql, (rs, i) -> this.createVersion(rs));
        HashMap<Integer, MpVersion> map = new HashMap<Integer, MpVersion>((int)((float)list.size() / 0.75f) + 1);
        for (MpVersion v : list) {
            map.put(v.getId(), v);
        }
        return map;
    }

    private MpVersion createVersion(ResultSet rs) throws SQLException {
        int vid = rs.getInt("id");
        int rid = rs.getInt("region_id");
        String region = rs.getString("code");
        String profileCode = rs.getString("profile_code");
        String version = rs.getString("versionnumber");
        boolean active = rs.getBoolean("active");
        Timestamp lastupdate = rs.getTimestamp("lastupdate");
        return new MpVersion(vid, rid, profileCode, region, version, active, lastupdate);
    }

    public Set<String> getFunctionsWithRegion(int regionId) {
        HashSet<String> result = new HashSet<String>();
        String sql = " select distinct f.$name from @function f   inner join @regionversion rv on f.regionversion_id = rv.id   inner join @region r on rv.region_id = r.id where f.$archive = 0   and r.id = ?";
        sql = this.dialect.parse(sql);
        this.jdbcTemplate().query(sql, new Object[]{regionId}, rs -> result.add(rs.getString(1)));
        return result;
    }

    public Set<String> getParametersWithRegion(int regionId) {
        HashSet<String> result = new HashSet<String>();
        String sql = " select distinct p.$name  from @parameter p   inner join @regionversion rv on p.regionversion_id = rv.id   inner join @region r on rv.region_id = r.id where p.$archive = 0       and r.id = ?";
        sql = this.dialect.parse(sql);
        this.jdbcTemplate().query(sql, new Object[]{regionId}, rs -> result.add(rs.getString(1)));
        return result;
    }

    public Map<String, ScheduleContainer> getAllSchedules() {
        HashMap<String, ScheduleContainer> map = new HashMap<String, ScheduleContainer>();
        this.jdbcTemplate().query(this.dialect.parse("select r.id, r.code, r.profile_code from @region r where r.archive = 0"), rs -> {
            String region = rs.getString("code");
            String profileCode = rs.getString("profile_code");
            map.computeIfAbsent(profileCode, code -> this.createScheduleContainer((String)code, region)).add(region, new MpSchedule(profileCode, region));
        });
        String sql = this.dialect.parse(" select r.code, r.profile_code, rv.versionnumber, s.regionversion_id, s.validfrom  from @regionversionschedule s    inner join @regionversion rv on s.regionversion_id = rv.id   inner join @region r on rv.region_id = r.id where rv.archive = 0 and r.archive = 0 order by s.validfrom");
        this.jdbcTemplate().query(sql, rs -> this.addEntry(map, rs));
        return map;
    }

    private void addEntry(Map<String, ScheduleContainer> map, ResultSet rs) throws SQLException {
        String region = rs.getString("code");
        String profileCode = rs.getString("profile_code");
        String ver = rs.getString("versionnumber");
        Date validFrom = this.dialect.getTimestamp(rs, "validfrom");
        this.getSchedule(map, profileCode, region).addEntry(new MpScheduleEntry(region, ver, validFrom));
    }

    public List<MpVersion> getUserRegionVersions(String profileCode, String user) {
        String query = "select rv.id, rv.region_id, r.code, r.profile_code, rv.versionnumber, rv.active, rv.lastupdate from @UserRegionVersion  urv inner join @regionversion rv on rv.id=urv.regionversion_id inner join @region r on r.id=rv.region_id where urv.username=?  and rv.archive=0  and r.archive=0  and r.profile_code=?";
        String sql = this.dialect.parse(query);
        return this.jdbcTemplate().query(sql, (rs, i) -> this.createVersion(rs), user, profileCode);
    }

    public SortedSet<Integer> getSystemVersions(String profile, SortedSet<Integer> versionsToOmit) {
        log.trace("getSystemVersionWithoutMy (profile={},versionsToOmit={})", (Object)profile, versionsToOmit);
        StringBuilder query = new StringBuilder("select rv.id as regionVersionId");
        query.append(" from @RegionVersion rv");
        query.append(" inner join @region r on r.id=rv.region_id");
        query.append(" where rv.active=1 and rv.archive=0");
        query.append(" and r.archive=0 and r.profile_code=?");
        if (!versionsToOmit.isEmpty()) {
            query.append(" and rv.region_id not in (");
            query.append(" select r2.region_id from @regionversion r2 where r2.id in (");
            query.append(this.getIdsToIn(versionsToOmit));
            query.append(" ) )");
        }
        String sql = this.dialect.parse(query.toString());
        TreeSet<Integer> result = new TreeSet<Integer>();
        this.jdbcTemplate().query(sql, (rs, i) -> {
            int idTmp = rs.getInt("regionVersionId");
            result.add(idTmp);
            return null;
        }, profile);
        return result;
    }

    private String getIdsToIn(Set<Integer> userRegionVersions) {
        StringBuilder result = new StringBuilder();
        for (Integer ver : userRegionVersions) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(ver);
        }
        return result.toString();
    }

    private ScheduleContainer createScheduleContainer(String profileCode, String region) {
        MpSchedule schedule = new MpSchedule(profileCode, region);
        ScheduleContainer container = new ScheduleContainer();
        container.add(region, schedule);
        return container;
    }

    private MpSchedule getSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return map.computeIfAbsent(profileCode, code -> this.createScheduleContainerWithSchedule((String)code, regionCode)).getSchedule(regionCode).orElseGet(this.createSchedule(map, profileCode, regionCode));
    }

    private ScheduleContainer createScheduleContainerWithSchedule(String profileCode, String regionCode) {
        ScheduleContainer container = new ScheduleContainer();
        MpSchedule schedule = new MpSchedule(profileCode, regionCode);
        container.add(regionCode, schedule);
        return container;
    }

    private Supplier<MpSchedule> createSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return () -> {
            MpSchedule schedule = new MpSchedule(profileCode, regionCode);
            ((ScheduleContainer)map.get(profileCode)).add(regionCode, schedule);
            return schedule;
        };
    }

    public List<String> getProfiles(String regionCode) {
        ArrayList<String> profiles = new ArrayList<String>();
        String sql = this.dialect.parse(" select r.profile_code from @region r where r.code = ? and r.$archive = 0");
        this.jdbcTemplate().query(sql, rs -> profiles.add(rs.getString("profile_code")), regionCode);
        return profiles;
    }

    public List<String> getProfiles(String regionCode, String version) {
        ArrayList<String> profiles = new ArrayList<String>();
        String sql = this.dialect.parse(" select r.profile_code from @region r inner join @regionversion rv on rv.region_id = r.id where r.code = ? and r.$archive = 0 and rv.versionnumber = ? and rv.$archive = 0");
        this.jdbcTemplate().query(sql, rs -> profiles.add(rs.getString("profile_code")), regionCode, version);
        return profiles;
    }
}

