/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.BaseDao;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.function.FunctionType;
import pl.decerto.hyperon.runtime.model.MpFunction;
import pl.decerto.hyperon.runtime.model.MpGroovyFunction;
import pl.decerto.hyperon.runtime.model.MpRhinoFunction;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;
import pl.decerto.hyperon.runtime.sync.Trackable;

public class FunctionJdbcDao
extends BaseDao {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();

    public FunctionJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
    }

    public MpFunction getFunction(String code, String ver, int sid) {
        this.log.debug("enter getFunction, code={}, ver={}, sid={}", new Object[]{code, ver, sid});
        boolean head = sid == 0;
        boolean version = ver != null;
        String sql = this.createSelect(version, head);
        this.log.trace("using sql: {}", (Object)sql);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(code);
        if (version) {
            args.add(ver);
        }
        if (!head) {
            args.add(sid);
        }
        MpFunction f = this.getOne(this.jdbcTemplate(), sql, (rs, rowNum) -> {
            String name = rs.getString("fname");
            String type = rs.getString("itype");
            int id = rs.getInt("fid");
            int implId = rs.getInt("iid");
            Timestamp lastupdate = rs.getTimestamp("flast");
            if (FunctionType.RHINO.code().equals(type)) {
                String args1 = rs.getString("ia");
                String body = rs.getString("ib");
                return new MpRhinoFunction(id, implId, name, args1, body, lastupdate);
            }
            if (FunctionType.GROOVY.code().equals(type)) {
                String args1 = rs.getString("ia");
                String body = rs.getString("ib");
                return new MpGroovyFunction(id, implId, name, args1, body, lastupdate);
            }
            this.log.warn("unsupported function type: {}", (Object)type);
            return null;
        }, args.toArray());
        this.log.debug("leave getFunction, found={}", (Object)f);
        return f;
    }

    public String createSelect(boolean version, boolean head) {
        StringBuilder sb = new StringBuilder();
        if (version) {
            this.append(" select", sb);
            this.append("   f.id as fid, f.$name as fname, f.lastupdate as flast,", sb);
            this.append("   impl.id as iid, impl.$type as itype, impl.args as ia, impl.body as ib", sb);
            this.append(" from @function f", sb);
            this.append("   inner join @functionimpl impl on f.implementation_id = impl.id", sb);
            this.append("   inner join @regionversion rv on f.regionversion_id = rv.id", sb);
            this.append(" where f.$name = ?", sb);
            this.append("   and f.$archive = 0", sb);
            this.append("   and rv.versionnumber = ?", sb);
            this.append("   and f.head = 1", sb, head);
            this.append("   and f.worksessionid = ?", sb, !head);
        } else {
            this.append(" select", sb);
            this.append("   f.id as fid, f.$name as fname, f.lastupdate as flast,", sb);
            this.append("   impl.id as iid, impl.$type as itype, impl.args as ia, impl.body as ib", sb);
            this.append(" from @function f", sb);
            this.append("   inner join @functionimpl impl on f.implementation_id = impl.id", sb);
            this.append("   left join @regionversion rv on f.regionversion_id = rv.id", sb);
            this.append(" where f.$name = ?", sb);
            this.append("   and f.$archive = 0", sb);
            this.append("   and (rv.active is null or rv.active = 1)", sb);
            this.append("   and f.head = 1", sb, head);
            this.append("   and f.worksessionid = ?", sb, !head);
        }
        String sql = sb.toString();
        return this.dialect.parse(sql);
    }

    public Date getMaxLastUpdate() {
        String sql = this.dialect.parse("select max(lastupdate) from @function");
        return this.jdbcTemplate().queryForObject(sql, Date.class);
    }

    public List<Trackable> getAllLastUpdates() {
        long t = System.currentTimeMillis();
        String sql = this.dialect.parse("select id, $name, lastupdate from @function where $archive = 0");
        List<Trackable> result = this.jdbcTemplate(1000).query(sql, (rs, i) -> new Trackable(rs.getInt(1), rs.getString(2), rs.getTimestamp(3)));
        this.log.debug("leave getAllLastUpdates, size={}, time={}", (Object)result.size(), (Object)(System.currentTimeMillis() - t));
        return result;
    }

    public List<MpFunction> getAllHeads() {
        return this.jdbcTemplate(500).query(this.dialect.parse(" select id, implementation_id, $name, $type, lastupdate, regionversion_id from @function where head = 1 and $archive = 0"), (rs, i) -> {
            int id = rs.getInt("id");
            int implId = rs.getInt("implementation_id");
            String name = this.dialect.getString(rs, "name");
            String type = this.dialect.getString(rs, "type");
            java.sql.Date lastupdate = this.dialect.getTimestamp(rs, "lastupdate");
            int rvid = rs.getInt("regionversion_id");
            return new MpFunction(id, implId, name, type, lastupdate, rvid);
        });
    }

    private void append(String line, StringBuilder sb) {
        sb.append(line);
    }

    private void append(String line, StringBuilder sb, boolean condition) {
        if (condition) {
            this.append(line, sb);
        }
    }
}

