/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.samples;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public interface Samples<V>
extends Iterable<V> {
    @Override
    public Iterator<V> iterator();

    public static enum Type {
        LIST_BASED,
        RANGE_BASED;

    }

    public static class DateRangeIterator
    extends BaseRangeIterator<Date> {
        private String stepType;

        public DateRangeIterator(RangeBasedSamples<Date> sampler, String stepType) {
            super(sampler);
            this.stepType = stepType;
        }

        @Override
        protected Date computeNext(Date current, BigDecimal step) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(current == null ? (Date)this.samples.min : current);
            switch (this.stepType) {
                case "m": {
                    cal.add(12, step.intValue());
                    break;
                }
                case "g": {
                    cal.add(11, step.intValue());
                    break;
                }
                case "d": {
                    cal.add(5, step.intValue());
                    break;
                }
                case "mc": {
                    cal.add(2, step.intValue());
                    break;
                }
                case "r": {
                    cal.add(1, step.intValue());
                    break;
                }
                default: {
                    cal.add(5, step.intValue());
                }
            }
            return cal.getTime();
        }

        @Override
        protected int compare(Date val1, Date val2) {
            return val1.compareTo(val2);
        }
    }

    public static class IntegerRangeIterator
    extends BaseRangeIterator<Integer> {
        public IntegerRangeIterator(RangeBasedSamples<Integer> sampler) {
            super(sampler);
        }

        @Override
        protected Integer computeNext(Integer val1, BigDecimal val2) {
            return val1 == null ? (Integer)this.samples.min : val1 + val2.intValue();
        }

        @Override
        protected int compare(Integer val1, Integer val2) {
            return val1.compareTo(val2);
        }
    }

    public static class BigDecimalRangeIterator
    extends BaseRangeIterator<BigDecimal> {
        public BigDecimalRangeIterator(RangeBasedSamples<BigDecimal> sampler) {
            super(sampler);
        }

        @Override
        protected int compare(BigDecimal val1, BigDecimal val2) {
            return val1.setScale(2).compareTo(val2.setScale(2));
        }

        @Override
        protected BigDecimal computeNext(BigDecimal current, BigDecimal step) {
            return BigDecimalRangeIterator.sum(current == null ? (BigDecimal)this.samples.min : current, step);
        }

        public static BigDecimal sum(BigDecimal val1, BigDecimal val2) {
            BigDecimal result = val1.add(val2);
            return result.setScale(4, 4);
        }
    }

    public static abstract class BaseRangeIterator<V>
    implements Iterator<V> {
        protected RangeBasedSamples<V> samples;
        protected V current;

        public BaseRangeIterator(RangeBasedSamples<V> sampler) {
            this.samples = sampler;
        }

        @Override
        public void remove() {
        }

        @Override
        public V next() {
            if (Objects.isNull(this.current)) {
                this.current = ((RangeBasedSamples)this.samples).min;
                return this.current;
            }
            if (this.hasNext()) {
                this.current = this.computeNext(this.current, ((RangeBasedSamples)this.samples).step);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return this.compare(this.computeNext(this.current, ((RangeBasedSamples)this.samples).step), ((RangeBasedSamples)this.samples).max) < 1;
        }

        protected abstract V computeNext(V var1, BigDecimal var2);

        protected abstract int compare(V var1, V var2);
    }

    public static class RangeBasedSamples<V>
    implements Samples<V> {
        private V min;
        private V max;
        private BigDecimal step;
        private Class<V> type;
        private String stepType;

        public RangeBasedSamples(Class<V> type, V min, V max, BigDecimal step) {
            this.type = type;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public RangeBasedSamples(Class<V> type, V min, V max, BigDecimal step, String stepType) {
            this(type, min, max, step);
            this.stepType = stepType;
        }

        @Override
        public Iterator<V> iterator() {
            if (BigDecimal.class.equals(this.type)) {
                return new BigDecimalRangeIterator(this);
            }
            if (Integer.class.equals(this.type)) {
                return new IntegerRangeIterator(this);
            }
            if (Date.class.equals(this.type)) {
                return new DateRangeIterator(this, this.stepType == null ? "" : this.stepType);
            }
            throw new RuntimeException("Seria wej\u015bciowa nie mo\u017ce by\u0107 u\u017cyta do iteracji lub nie jest poprawnie zdefiniowana w SandBox.");
        }
    }

    public static class ListBasedSamples<V>
    implements Samples<V> {
        private List<V> values;

        public ListBasedSamples(List<V> values) {
            this.values = values;
        }

        @Override
        public Iterator<V> iterator() {
            return this.values.iterator();
        }
    }
}

