/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.charge;

import java.math.BigDecimal;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;

public class StdUnitChargeToDebtCollector {
    public void collectChargeToDeptForFund(SimulationLifeContext context, boolean divideByMonths) {
        ChargeValueDefinition chargeValue;
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        ChargeDefinition chargeDefinition = context.getCurrentChargeDefinition();
        InvestPolicyValueSimulationContext.Fund fund = context.getCurrentFund();
        ChargeValueDefinition chargeValueDefinition = chargeValue = divideByMonths ? this.getChargeValue(context) : ChargeValueDefinition.getChargeValueDefinition(context);
        if (SimulationMathematicalFunctions.greaterThanZero(chargeValue.getValue())) {
            BigDecimal fundChargeAmount = this.calculateFundChargeAmountBasedOnUnitsCount(fund, chargeValue);
            BigDecimal fundChargeInUnits = SimulationMathematicalFunctions.divide(fundChargeAmount, fund.getUnitPrice());
            account.addChargeToDebt(new InvestPolicyValueSimulationContext.FundCharge(fund.getFundDefinition(), fundChargeInUnits, chargeDefinition, chargeValue));
        }
    }

    private ChargeValueDefinition getChargeValue(SimulationLifeContext context) {
        ChargeValueDefinition valueDefinition = ChargeValueDefinition.getChargeValueDefinition(context);
        return new ChargeValueDefinition(SimulationMathematicalFunctions.divide(valueDefinition.getValue(), SimulationMathematicalFunctions.NUMBER_OF_MONTHS), valueDefinition.getType());
    }

    private BigDecimal calculateFundChargeAmountBasedOnUnitsCount(InvestPolicyValueSimulationContext.Fund fund, ChargeValueDefinition chargeValue) {
        BigDecimal units = fund.calculateUnitsAverage();
        return chargeValue.calculateAmount(SimulationMathematicalFunctions.multiply(units, fund.getUnitPrice()));
    }
}

