/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.charge;

import java.math.BigDecimal;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;

public class RateReturnChargeCollector {
    public void collectCharge(SimulationLifeContext context) {
        SimulationLife simulationData = context.getSimulationData();
        InvestPolicyValueSimulationContext.Fund fund = context.getCurrentFund();
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        ChargeValueDefinition annualChargeDefinition = ChargeValueDefinition.getChargeValueDefinition(context);
        this.updateFundRates(fund, simulationData.getPeriodNumber(), annualChargeDefinition);
        this.collectCharge(fund, simulationData.getPeriodNumber(), account, annualChargeDefinition, context.getCurrentChargeDefinition(), context.getChargePhase());
    }

    private void collectCharge(InvestPolicyValueSimulationContext.Fund fund, int processedMonth, InvestPolicyValueSimulationContext.SuspenseAccount account, ChargeValueDefinition annualChargeDefinition, ChargeDefinition chargeDefinition, String phase) {
        if (annualChargeDefinition != null) {
            BigDecimal priceWithoutCharge = SimulationMathematicalFunctions.calculateMonthUnitPrice(processedMonth, SimulationMathematicalFunctions.calculateMonthEffectiveRateReturn(fund.getAnnualRateReturn()));
            BigDecimal boughtUnitsWithoutCharge = SimulationMathematicalFunctions.divide(fund.getAmountToInvest(), priceWithoutCharge);
            BigDecimal chargeInUnits = SimulationMathematicalFunctions.subtract(fund.getBoughtUnits(), boughtUnitsWithoutCharge);
            if (SimulationMathematicalFunctions.greaterThanZero(chargeInUnits)) {
                CollectedCharge collectecCharge = new CollectedCharge(account.getCode(), chargeDefinition, annualChargeDefinition);
                collectecCharge.setPhase(phase);
                account.addCollectedCharge(collectecCharge.withChargedAmount(SimulationMathematicalFunctions.multiply(chargeInUnits, fund.getUnitPrice())).withChargedUnits(fund.getCode(), chargeInUnits));
            }
        }
    }

    private void updateFundRates(InvestPolicyValueSimulationContext.Fund fund, int processedMonth, ChargeValueDefinition annualChargeDefinition) {
        if (SimulationMathematicalFunctions.isFirstMonthOfYear(processedMonth)) {
            BigDecimal annualRateReturnCharge = annualChargeDefinition.getValue();
            BigDecimal actualRateReturn = SimulationMathematicalFunctions.subtract(fund.getAnnualRateReturn(), annualRateReturnCharge);
            BigDecimal monthlyEffectiveRateReturn = SimulationMathematicalFunctions.calculateMonthEffectiveRateReturn(actualRateReturn);
            fund.setUnitPrice(SimulationMathematicalFunctions.calculateMonthUnitPrice(processedMonth, monthlyEffectiveRateReturn));
            fund.setMonthlyEffectiveRateReturn(monthlyEffectiveRateReturn);
        }
    }
}

