/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.context.DefaultContext;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

public class FundDataRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FundDataRepository.class);
    public static final String FUND_PARAM = "a2.life.auto.dict.fund";
    public static final String LEVEL_ID_FUNDUSZU = "fundID";
    public static final String LEVEL_KROTKA_NAZWA_FUNDUSZU = "fundShortName";
    public static final String LEVEL_PELNA_NAZWA_FUNDUSZU = "fundName";
    private static final String RATE_RETURN_PARAM = "a2.life.fund.profitability";
    private static final String GROUP_PARAM = "a2.life.fund.group";
    private static final String F2G_PARAM = "a2.life.fund.to.group";
    private static final String GROUP_TYPE = "GROUP";
    private HyperonEngine mpEngine;

    public void setup(HyperonEngine mpEngine) {
        this.mpEngine = mpEngine;
    }

    public BigDecimal getAnnualRateReturn(String itemType, String itemCode, int yearNumber, String variant) {
        return this.getAnnualRateReturn(itemType, itemCode, null, yearNumber, variant);
    }

    private BigDecimal getAnnualRateReturn(String itemType, String itemCode, String itemParentCode, int yearNumber, String variant) {
        BigDecimal rateReturn = this.getAnnualInvestItemRateReturn(itemType, itemCode, yearNumber, variant);
        if (rateReturn == null) {
            String[] parent = this.getParentGroupData(itemType, itemCode, itemParentCode);
            rateReturn = parent != null ? this.getAnnualRateReturn(GROUP_TYPE, parent[0], parent[2], yearNumber, variant) : null;
        }
        return rateReturn == null ? BigDecimal.ZERO : rateReturn;
    }

    private BigDecimal getAnnualInvestItemRateReturn(String itemType, String itemCode, int yearNumber, String variant) {
        try {
            ParamValue rateReturn = this.mpEngine.get(RATE_RETURN_PARAM, new DefaultContext().with("simulation.item.type", itemType).with("simulation.item.code", itemCode).with("simulation.year", yearNumber).with("simulation.variant", variant));
            return rateReturn != null ? rateReturn.getBigDecimal() : null;
        }
        catch (ParameterValueNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public String getInvestmentItemName(String fundParam, String code, String type) {
        if (GROUP_TYPE.equals(type)) {
            return this.getGroupName(code);
        }
        return this.getFundName(fundParam, code);
    }

    private String getFundName(String fundParam, String fundId) {
        List<String[]> data = this.getFundsData(fundParam, new Date(), fundId);
        return CollectionUtils.isNotEmpty(data) ? data.get(0)[1] : fundId;
    }

    private String getGroupName(String code) {
        String[] group = this.getGroupDataByCode(code);
        return group != null ? group[1] : null;
    }

    public String[] getParentGroupData(String type, String code, String parentCode) {
        if (parentCode == null) {
            String[] data = GROUP_TYPE.equals(code) ? this.getGroupDataByCode(code) : this.getFundDataById(code);
            parentCode = data != null ? data[2] : null;
        }
        return parentCode == null ? null : this.getGroupDataByCode(parentCode);
    }

    public String[] getGroupDataByCode(String code) {
        ParamValue value;
        try {
            value = this.mpEngine.get(GROUP_PARAM, new DefaultContext());
        }
        catch (ParameterValueNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
        if (value == null) {
            return null;
        }
        for (MultiValue row : value.rows()) {
            if (!row.getString("code").equals(code)) continue;
            return new String[]{row.getString(0), row.getString(1), row.getString(2)};
        }
        return null;
    }

    public String[] getFundDataById(String fundId) {
        ParamValue value = null;
        try {
            value = this.mpEngine.get(F2G_PARAM, new DefaultContext());
        }
        catch (ParameterValueNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
        if (value == null) {
            return null;
        }
        for (MultiValue row : value.rows()) {
            if (!row.getString(0).equals(fundId)) continue;
            return new String[]{row.getString(0), row.getString(0), row.getStringArray(1)[0]};
        }
        return null;
    }

    public List<String[]> getFundsData(String fundParam, Date vd, String ... ids) {
        ParamValue value;
        try {
            value = this.mpEngine.get(fundParam, new DefaultContext().with("proposal.calculationDate", vd, true));
        }
        catch (ParameterValueNotFoundException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
        if (value == null) {
            return null;
        }
        ArrayList<String[]> funds = new ArrayList<String[]>(value.size());
        for (MultiValue row : value.rows()) {
            if (!ArrayUtils.isEmpty((Object[])ids) && !ArrayUtils.contains((Object[])ids, (Object)row.getString(LEVEL_ID_FUNDUSZU))) continue;
            funds.add(new String[]{row.getString(LEVEL_ID_FUNDUSZU), row.getString(LEVEL_PELNA_NAZWA_FUNDUSZU), row.getString(LEVEL_KROTKA_NAZWA_FUNDUSZU)});
        }
        return funds;
    }
}

