/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.runtime.core.AdhocContext;
import pl.decerto.hyperon.runtime.core.EmptyParamValue;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.helper.TypeConverter;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;

public abstract class AbstractDom<T> {
    private static final ParamValue EMPTY_PARAM_VALUE = new EmptyParamValue();
    private static final String PATH_DOMAIN_CODE = "domain.code";
    private static final String PATH_DOMAIN_TYPE = "domain.type";
    private static final String PATH_DOMAIN_NAME = "domain.name";
    private static final String PATH_DOMAIN_PATH = "domain.path";
    protected final HyperonDomainObject domObj;
    protected HyperonContext ctx;
    protected TypeConverter typeConverter = new TypeConverter();

    public AbstractDom(HyperonDomainObject domObj) {
        if (domObj == null) {
            throw new IllegalArgumentException("Domain object can't be null");
        }
        this.domObj = domObj;
        this.ctx = this.defaultCtx(null);
    }

    protected HyperonContext defaultCtx(HyperonContext parent) {
        AdhocContext ctx = parent != null ? new AdhocContext(parent) : new AdhocContext(new Object[0]);
        this.setStandardFields(ctx);
        return ctx;
    }

    public T with(HyperonContext ctx) {
        this.ctx = this.defaultCtx(ctx);
        return (T)this;
    }

    public T with(String key, Object value) {
        this.ctx.with(key, value, true);
        return (T)this;
    }

    public T with(String key, HyperonContext subContext) {
        if (!this.usesAdhocContext()) {
            this.ctx = new AdhocContext(this.ctx);
        }
        this.ctx.with(key, subContext, true);
        return (T)this;
    }

    public String code() {
        return this.domObj.getCode();
    }

    public String name() {
        return this.domObj.getName();
    }

    protected void setStandardFields(HyperonContext ctx) {
        ctx.with(PATH_DOMAIN_CODE, this.domObj.getCode(), false);
        ctx.with(PATH_DOMAIN_TYPE, this.domObj.getTypeCode(), false);
        ctx.with(PATH_DOMAIN_NAME, this.domObj.getName(), false);
        ctx.with(PATH_DOMAIN_PATH, this.domObj.getCallPath(), false);
    }

    protected List<HyperonDomainObject> getChildren(String propertyCode) {
        return this.domObj.getChildren(propertyCode);
    }

    protected HyperonDomainObject getChild(String propertyCode, String code) {
        return this.domObj.getChild(propertyCode, code);
    }

    protected <C extends AbstractDom> C getChild(String property, Function<HyperonDomainObject, C> mapper) {
        return this.getChild(property, null, mapper);
    }

    protected <C extends AbstractDom> C getChild(String property, String code, Function<HyperonDomainObject, C> mapper) {
        HyperonDomainObject child = this.domObj.getChild(property, code);
        return (C)(child != null ? (AbstractDom)((AbstractDom)mapper.apply(child)).with(this.ctx) : null);
    }

    protected boolean hasChild(String propertyCode, String code) {
        return this.getChild(propertyCode, code) != null;
    }

    protected HyperonDomainObject getParent() {
        return this.domObj.getParent();
    }

    protected <R extends AbstractDom<R>> List<R> all(String childCode, Function<? super HyperonDomainObject, R> transform) {
        return this.getChildren(childCode).stream().map(childDomObj -> this.createDom((HyperonDomainObject)childDomObj, transform)).collect(Collectors.toList());
    }

    protected <R extends AbstractDom<R>> R one(String codeForChildren, String childCode, Function<? super HyperonDomainObject, R> transform) {
        HyperonDomainObject child = this.getChild(codeForChildren, childCode);
        if (child == null) {
            throw new IllegalArgumentException(String.format("Unable to find element %s in %s in %s", childCode, codeForChildren, this.code()));
        }
        return this.createDom(child, transform);
    }

    protected <R extends AbstractDom<R>> R one(String codeForChildren, Function<? super HyperonDomainObject, R> transform) {
        List<HyperonDomainObject> children = this.getChildren(codeForChildren);
        if (children == null) {
            throw new IllegalArgumentException(String.format("Unable to find one element in %s in %s", codeForChildren, this.code()));
        }
        if (children.size() != 1) {
            throw new IllegalArgumentException(String.format("Unable to fetch one element in %s in %s. Wrong size %d", codeForChildren, this.code(), children.size()));
        }
        return this.createDom(this.getLastFrom(children), transform);
    }

    private HyperonDomainObject getLastFrom(List<HyperonDomainObject> children) {
        int maxSize = children.size();
        return children.get(maxSize - 1);
    }

    protected <R extends AbstractDom<R>> R parent(Function<? super HyperonDomainObject, R> transform) {
        return this.createDom(this.getParent(), transform);
    }

    protected ParamValue getAttrValue(String code, Object ... args) {
        if (!this.domObj.isAttrDefined(code)) {
            throw new IllegalArgumentException(String.format("cannot find attribute %s in the %s[%s]", code, this.domObj.getTypeCode(), this.domObj.getCode()));
        }
        ParamValue pv = this.domObj.getAttributeValue(null, code, this.ctx, args);
        return pv != null ? pv : EMPTY_PARAM_VALUE;
    }

    protected String getAttrString(String code, Object ... args) {
        return this.typeConverter.getString(this.valueObject(code, args));
    }

    protected boolean getAttrBoolean(String code, Object ... functionArgs) {
        return this.typeConverter.getBoolean(this.valueObject(code, functionArgs));
    }

    protected BigDecimal getAttrDecimal(String code, Object ... args) {
        return this.typeConverter.getDecimal(this.valueObject(code, args));
    }

    protected double getAttrNumber(String code, Object ... args) {
        return this.typeConverter.getNumber(this.valueObject(code, args));
    }

    protected Integer getAttrInteger(String code, Object ... args) {
        return this.typeConverter.getInteger(this.valueObject(code, args));
    }

    protected Long getAttrLong(String code, Object ... args) {
        return this.typeConverter.getLong(this.valueObject(code, args));
    }

    protected Date getAttrDate(String code, Object ... args) {
        return this.typeConverter.getDate(this.valueObject(code, args));
    }

    protected Object getAttrObject(String code, Object ... args) {
        return this.valueObject(code, args);
    }

    protected <R> List<R> getAttrList(String code, Function<MultiValue, R> valueConverter, Object ... args) {
        ParamValue pv = this.getAttrValue(code, args);
        return this.getAttrList(pv, valueConverter);
    }

    protected <R> Set<R> getAttrSet(String code, Function<MultiValue, R> valueConverter, Object ... args) {
        ParamValue pv = this.getAttrValue(code, args);
        return this.getAttrSet(pv, valueConverter);
    }

    protected <R extends Enum<R>> R getAttrEnum(Class<R> enumType, String code, Object ... args) {
        String strValue = this.getAttrString(code, args);
        return StringUtils.isBlank((CharSequence)strValue) ? null : (R)Enum.valueOf(enumType, strValue);
    }

    protected List<String> getAttrStringList(String code) {
        return this.getAttrList(code, mv -> this.typeConverter.getString(this.valueObject((MultiValue)mv)), new Object[0]);
    }

    protected Set<String> getAttrStringSet(String code) {
        return this.getAttrSet(code, mv -> this.typeConverter.getString(this.valueObject((MultiValue)mv)), new Object[0]);
    }

    protected ParamValue getDynamicAttrValue(String code, Object ... args) {
        ParamValue pv = this.domObj.getDynamicAttribute(code) != null ? this.domObj.getDynamicAttribute(code).getValue(this.ctx, args) : null;
        return pv != null ? pv : EMPTY_PARAM_VALUE;
    }

    protected String getDynamicAttrString(String code, Object ... args) {
        return this.typeConverter.getString(this.dynamicValueObject(code, args));
    }

    protected BigDecimal getDynamicAttrDecimal(String code, Object ... args) {
        return this.typeConverter.getDecimal(this.dynamicValueObject(code, args));
    }

    protected double getDynamicAttrNumber(String code, Object ... args) {
        return this.typeConverter.getNumber(this.dynamicValueObject(code, args));
    }

    protected Integer getDynamicAttrInteger(String code, Object ... args) {
        return this.typeConverter.getInteger(this.dynamicValueObject(code, args));
    }

    protected Long getDynamicAttrLong(String code, Object ... args) {
        return this.typeConverter.getLong(this.dynamicValueObject(code, args));
    }

    protected Date getDynamicAttrDate(String code, Object ... args) {
        return this.typeConverter.getDate(this.dynamicValueObject(code, args));
    }

    protected boolean getDynamicAttrBoolean(String code, Object ... args) {
        return this.typeConverter.getBoolean(this.dynamicValueObject(code, args));
    }

    protected Object getDynamicAttrObject(String code, Object ... args) {
        return this.dynamicValueObject(code, args);
    }

    protected <R extends Enum<R>> R getDynamicAttrEnum(Class<R> enumType, String code, Object ... args) {
        String strValue = this.getDynamicAttrString(code, args);
        return StringUtils.isBlank((CharSequence)strValue) ? null : (R)Enum.valueOf(enumType, strValue);
    }

    protected <R> List<R> getDynamicAttrList(String code, Function<MultiValue, R> valueConverter, Object ... args) {
        ParamValue pv = this.getDynamicAttrValue(code, args);
        return this.getAttrList(pv, valueConverter);
    }

    protected <R> Set<R> getDynamicAttrSet(String code, Function<MultiValue, R> valueConverter, Object ... args) {
        ParamValue pv = this.getDynamicAttrValue(code, args);
        return this.getAttrSet(pv, valueConverter);
    }

    protected List<String> getDynamicAttrStringList(String code) {
        return this.getDynamicAttrList(code, mv -> this.typeConverter.getString(this.valueObject((MultiValue)mv)), new Object[0]);
    }

    protected Set<String> getDynamicAttrStringSet(String code) {
        return this.getDynamicAttrSet(code, mv -> this.typeConverter.getString(this.valueObject((MultiValue)mv)), new Object[0]);
    }

    private <R> List<R> getAttrList(ParamValue pv, Function<MultiValue, R> valueConverter) {
        return StreamSupport.stream(pv.spliterator(), false).map(valueConverter).collect(Collectors.toList());
    }

    private <R> Set<R> getAttrSet(ParamValue pv, Function<MultiValue, R> valueConverter) {
        return StreamSupport.stream(pv.spliterator(), false).map(valueConverter).collect(Collectors.toSet());
    }

    private Object valueObject(String attrCode, Object ... args) {
        ValueHolder holder = this.getAttrValue(attrCode, args).getHolder();
        return this.valueObject(holder);
    }

    private Object dynamicValueObject(String dynamicAttrCode, Object ... args) {
        ValueHolder holder = this.getDynamicAttrValue(dynamicAttrCode, args).getHolder();
        return this.valueObject(holder);
    }

    private Object valueObject(MultiValue mv) {
        ValueHolder holder = mv.getHolder(0);
        return this.valueObject(holder);
    }

    private Object valueObject(ValueHolder holder) {
        return holder != null ? holder.getValue() : null;
    }

    private <R extends AbstractDom<R>> R createDom(HyperonDomainObject hyperDomainObject, Function<? super HyperonDomainObject, R> constr) {
        AbstractDom dom = (AbstractDom)constr.apply(hyperDomainObject);
        dom.with(this.ctx);
        return (R)dom;
    }

    private boolean usesAdhocContext() {
        return this.ctx instanceof AdhocContext;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("domObj", (Object)this.domObj).append("ctx", (Object)this.ctx).toString();
    }
}

