/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.config;

import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.smartparam.engine.config.ParamEngineConfig;
import org.smartparam.engine.config.initialization.BasicComponentInitializerRunner;
import org.smartparam.engine.config.initialization.ComponentInitializerRunner;
import org.smartparam.engine.config.pico.PicoContainerUtil;
import org.smartparam.engine.config.pico.PicoParamEngineRuntimeConfigBuilder;
import org.smartparam.engine.core.ParamEngine;
import org.smartparam.engine.core.SmartParamEngine;
import org.smartparam.engine.core.function.FunctionProvider;
import org.smartparam.engine.core.function.InvokerRepository;
import org.smartparam.engine.core.matcher.MatcherRepository;
import org.smartparam.engine.core.parameter.ParameterProvider;
import org.smartparam.engine.core.type.TypeRepository;

public class ParamEngineFactory {
    public static ParamEngine paramEngine(ParamEngineConfig config) {
        return new ParamEngineFactory().createParamEngine(config);
    }

    public ParamEngine createParamEngine(ParamEngineConfig config) {
        ComponentInitializerRunner initializerRunner = this.prepareInitializerRunner(config);
        MutablePicoContainer picoContainer = PicoContainerUtil.createContainer();
        picoContainer.addComponent(SmartParamEngine.class);
        PicoContainerUtil.injectImplementations(picoContainer, config.getComponents());
        picoContainer.addComponent((Object)new PicoParamEngineRuntimeConfigBuilder((PicoContainer)picoContainer));
        ParamEngine engine = (ParamEngine)picoContainer.getComponent(ParamEngine.class);
        this.initializeRepositories((PicoContainer)picoContainer, config, initializerRunner);
        initializerRunner.runInitializersOnList(picoContainer.getComponents());
        return engine;
    }

    private ComponentInitializerRunner prepareInitializerRunner(ParamEngineConfig config) {
        if (config.getInitializationRunner() == null) {
            BasicComponentInitializerRunner initializerRunner = new BasicComponentInitializerRunner();
            initializerRunner.registerInitializers(config.getComponentInitializers());
            config.setInitializationRunner(initializerRunner);
        }
        return config.getInitializationRunner();
    }

    private void initializeRepositories(PicoContainer container, ParamEngineConfig config, ComponentInitializerRunner initializerRunner) {
        initializerRunner.runInitializersOnList(config.getParameterRepositories());
        ((ParameterProvider)container.getComponent(ParameterProvider.class)).registerAll(config.getParameterRepositories());
        initializerRunner.runInitializersOnList(config.getFunctionRepositories().values());
        ((FunctionProvider)container.getComponent(FunctionProvider.class)).registerWithKeys(config.getFunctionRepositories());
        ((InvokerRepository)container.getComponent(InvokerRepository.class)).registerAll(config.getFunctionInvokers());
        ((TypeRepository)container.getComponent(TypeRepository.class)).registerAll(config.getTypes());
        ((MatcherRepository)container.getComponent(MatcherRepository.class)).registerAll(config.getMatchers());
    }
}

