/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.model.MpElementType;
import pl.decerto.hyperon.runtime.model.MpSchedule;
import pl.decerto.hyperon.runtime.model.MpVersion;
import pl.decerto.hyperon.runtime.model.region.ScheduleContainer;

public class ScheduleCache {
    private final Map<String, MpSchedule> parSchedules;
    private final Map<String, MpSchedule> funSchedules;
    private final Map<String, ScheduleContainer> profileToSchedulesMapping;
    private final int hash;
    private final Collection<MpVersion> allVersions;
    private final Set<String> regionCodes;

    public ScheduleCache(Map<String, MpSchedule> parSchedules, Map<String, MpSchedule> funSchedules, Map<String, ScheduleContainer> profileToSchedulesMapping, int hash, Collection<MpVersion> allVersions) {
        this.parSchedules = parSchedules;
        this.funSchedules = funSchedules;
        this.profileToSchedulesMapping = profileToSchedulesMapping;
        this.hash = hash;
        this.allVersions = allVersions;
        this.regionCodes = new TreeSet<String>();
        for (MpVersion rv : allVersions) {
            this.regionCodes.add(rv.getRegion());
        }
    }

    public MpVersion getActiveVersion(String regionCode) {
        for (MpVersion rv : this.allVersions) {
            if (!rv.getRegion().equals(regionCode) || !rv.isActive()) continue;
            return rv;
        }
        return null;
    }

    public Optional<MpVersion> getActiveVersion(String profileCode, String regionCode) {
        return this.allVersions.stream().filter(rv -> rv.getProfileCode().equals(profileCode) && rv.getRegion().equals(regionCode) && rv.isActive()).findFirst();
    }

    public MpVersion getVersionData(String region, String version) {
        return this.allVersions.stream().filter(rv -> rv.getRegion().equals(region) && rv.getNumber().equals(version)).findFirst().orElse(null);
    }

    public Optional<MpVersion> getVersionData(String profileCode, String regionCode, String version) {
        for (MpVersion rv : this.allVersions) {
            if (!rv.getProfileCode().equals(profileCode) || !rv.getRegion().equals(regionCode) || !rv.getNumber().equals(version)) continue;
            return Optional.of(rv);
        }
        return Optional.empty();
    }

    public int getHash() {
        return this.hash;
    }

    public MpSchedule getParameterSchedule(String parameterCode) {
        return this.parSchedules.get(parameterCode);
    }

    public MpSchedule getFunctionSchedule(String functionCode) {
        return this.funSchedules.get(functionCode);
    }

    public MpSchedule getSchedule(String elementCode, MpElementType type) {
        switch (type) {
            case PARAMETER: {
                return this.getParameterSchedule(elementCode);
            }
            case FUNCTION: {
                return this.getFunctionSchedule(elementCode);
            }
        }
        throw new HyperonRuntimeException("unexpected MpSchedule.ElementType: " + (Object)((Object)type));
    }

    public Optional<ScheduleContainer> getSchedules(String profileCode) {
        return Optional.ofNullable(this.profileToSchedulesMapping.get(profileCode));
    }

    public String toString() {
        return "ScheduleCache[hash=" + this.hash + ", #par=" + this.parSchedules.size() + ", #fun=" + this.funSchedules.size() + ", #sch=" + this.profileToSchedulesMapping.size() + ", #reg=" + this.regionCodes.size() + ", #ver=" + this.allVersions.size() + ']';
    }
}

