/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.prepared.CacheEntry;
import pl.decerto.hyperon.runtime.model.MpFunction;
import pl.decerto.hyperon.runtime.model.MpPropFunction;

public abstract class RuntimeWatcherHelper {
    private static final Logger log = LoggerFactory.getLogger(RuntimeWatcherHelper.class);

    public static void invalidateFunction(FunctionCache cache, int id) {
        log.debug("invalidating fc for fid: {}", (Object)id);
        boolean found = false;
        for (CacheEntry<Function> entry : cache.list()) {
            MpFunction f = (MpFunction)entry.getValue();
            if (f.getId() != id) continue;
            if (f instanceof MpPropFunction) break;
            String key = entry.getKey();
            cache.invalidate(key);
            log.debug("found and invalidated: [{}] -> {}", (Object)key, (Object)f);
            found = true;
            break;
        }
        if (!found) {
            log.debug("f not found in fc");
        }
    }
}

