/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino.helper;

import java.util.Map;
import java.util.TreeMap;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.helper.TypeConverter;

public class MultiValueBuilder {
    private static TypeConverter type = new TypeConverter();
    private String[] codes;
    private String[] types;
    private Object[] values;

    public MultiValueBuilder withCodes(String ... codes) {
        this.codes = codes;
        return this;
    }

    public MultiValueBuilder withTypes(String ... types) {
        this.types = types;
        return this;
    }

    public MultiValueBuilder withValues(Object ... columns) {
        this.values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Object column = columns[i];
            if (column instanceof ValueHolder || column instanceof ValueHolder[]) {
                this.values[i] = column;
                continue;
            }
            if (this.types != null && this.types[i] != null) {
                this.values[i] = type.toHolder(column, this.types[i]);
                continue;
            }
            throw new HyperonRuntimeException("Unable to create multivalue for column index: " + i);
        }
        return this;
    }

    public MultiValue build() {
        Map<String, Integer> indexMap = this.codes != null ? this.toIndexMap(this.codes) : null;
        return new MultiValue(this.values, indexMap);
    }

    private Map<String, Integer> toIndexMap(String ... outCodes) {
        TreeMap<String, Integer> indexMap = new TreeMap<String, Integer>();
        for (int i = 0; i < outCodes.length; ++i) {
            indexMap.put(outCodes[i], i);
        }
        return indexMap;
    }
}

