/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.rhino.domain.RhinoDomainAttribute;
import pl.decerto.hyperon.runtime.rhino.domain.RhinoDomainNullAttribute;
import pl.decerto.hyperon.runtime.rhino.value.RhinoParamValue;

public class RhinoDomainElement {
    private static final char SEP = "/".charAt(0);
    private static final RhinoDomainAttribute NULL_ATTR = new RhinoDomainNullAttribute();
    private final HyperonDomainObject obj;
    private final HyperonContext ctx;

    public RhinoDomainElement(HyperonDomainObject obj, HyperonContext ctx) {
        this.obj = obj;
        this.ctx = ctx;
    }

    public RhinoDomainElement get(String path) {
        return this.get(path, true);
    }

    private RhinoDomainElement get(String path, boolean throwExceptionIfNotFound) {
        String[] pathTokens = EngineUtil.split(path, SEP);
        HyperonDomainObject curr = this.obj;
        for (String token : pathTokens) {
            if (!StringUtils.isNotBlank((CharSequence)token) || !Objects.isNull(curr = this.getDomainElement(curr, token))) continue;
            return this.resolveNotExistingElement(path, throwExceptionIfNotFound);
        }
        return new RhinoDomainElement(curr, this.ctx);
    }

    private RhinoDomainElement resolveNotExistingElement(String path, boolean throwExceptionIfNotFound) {
        if (throwExceptionIfNotFound) {
            throw new HyperonRuntimeException(String.format("Unknown path: %s/%s", this.path(this.obj), path));
        }
        return null;
    }

    private HyperonDomainObject getDomainElement(HyperonDomainObject curr, String token) {
        int sepIndex = token.indexOf(91);
        String collectionCode = token.substring(0, sepIndex == -1 ? token.length() : sepIndex);
        String code = null;
        if (sepIndex != -1) {
            code = token.substring(sepIndex + 1, token.length() - 1);
        }
        curr = curr.getChild(collectionCode, code);
        return curr;
    }

    public RhinoDomainElement getSafe(String path) {
        return this.get(path, false);
    }

    public RhinoDomainElement getSafe(String childType, String childCode) {
        return this.get(childType, childCode, false);
    }

    public RhinoDomainElement get(String childType, String childCode) {
        return this.get(childType, childCode, true);
    }

    private RhinoDomainElement get(String childType, String childCode, boolean throwExceptionIfNotFound) {
        HyperonDomainObject child = this.obj.getChild(childType, childCode);
        if (child == null) {
            if (throwExceptionIfNotFound) {
                throw new HyperonRuntimeException(String.format("Unknown path: %s/%s[%s]", this.path(this.obj), childType, childCode));
            }
            return null;
        }
        return new RhinoDomainElement(child, this.ctx);
    }

    public List<RhinoDomainElement> getAll(String childType) {
        List<HyperonDomainObject> children = this.obj.getChildren(childType);
        ArrayList<RhinoDomainElement> all = new ArrayList<RhinoDomainElement>(children.size());
        for (HyperonDomainObject child : children) {
            all.add(new RhinoDomainElement(child, this.ctx));
        }
        return all;
    }

    public RhinoDomainAttribute attr(String code) {
        HyperonDomainAttribute attr = this.obj.getAttribute(code);
        if (attr == null) {
            attr = this.obj.getDynamicAttribute(code);
        }
        if (attr != null) {
            return new RhinoDomainAttribute(attr, this.ctx);
        }
        return null;
    }

    private RhinoDomainAttribute getAttribute(String code) {
        RhinoDomainAttribute attr = this.attr(code);
        return attr != null ? attr : NULL_ATTR;
    }

    public RhinoDomainAttribute staticAttr(String code) {
        HyperonDomainAttribute attr = this.obj.getAttribute(code);
        if (attr != null) {
            return new RhinoDomainAttribute(attr, this.ctx);
        }
        return null;
    }

    public RhinoDomainAttribute dynamicAttr(String code) {
        HyperonDomainAttribute attr = this.obj.getDynamicAttribute(code);
        if (attr != null) {
            return new RhinoDomainAttribute(attr, this.ctx);
        }
        return null;
    }

    public String getAttrString(String code, HyperonContext ctx) {
        return this.getAttribute(code).getString(ctx);
    }

    public String getAttrString(String code) {
        return this.getAttribute(code).getString();
    }

    public BigDecimal getAttrDecimal(String code, HyperonContext ctx) {
        return this.getAttribute(code).getDecimal(ctx);
    }

    public BigDecimal getAttrDecimal(String code) {
        return this.getAttribute(code).getDecimal();
    }

    public double getAttrNumber(String code, HyperonContext ctx) {
        return this.getAttribute(code).getNumber(ctx);
    }

    public double getAttrNumber(String code) {
        return this.getAttribute(code).getNumber();
    }

    public Integer getAttrInteger(String code, HyperonContext ctx) {
        return this.getAttribute(code).getInteger(ctx);
    }

    public Integer getAttrInteger(String code) {
        return this.getAttribute(code).getInteger();
    }

    public Date getAttrDate(String code, HyperonContext ctx) {
        return this.getAttribute(code).getDate(ctx);
    }

    public Date getAttrDate(String code) {
        return this.getAttribute(code).getDate();
    }

    public RhinoParamValue getAttrValue(String code, HyperonContext ctx) {
        return this.getAttribute(code).getValue(ctx);
    }

    public RhinoParamValue getAttrValue(String code) {
        return this.getAttribute(code).getValue();
    }

    public boolean getAttrBoolean(String code, HyperonContext ctx) {
        return this.getAttribute(code).getBoolean(ctx);
    }

    public boolean getAttrBoolean(String code) {
        return this.getAttribute(code).getBoolean();
    }

    public boolean hasStaticAttr(String code) {
        return this.obj.getAttribute(code) != null;
    }

    public boolean hasDynamicAttr(String code) {
        return this.obj.getDynamicAttribute(code) != null;
    }

    public boolean hasAttr(String code) {
        return this.hasStaticAttr(code) || this.hasDynamicAttr(code);
    }

    public String code() {
        return this.obj.getCode();
    }

    public String name() {
        return this.obj.getName();
    }

    public RhinoDomainElement parent() {
        return new RhinoDomainElement(this.obj.getParent(), this.ctx);
    }

    public HyperonDomainObject unwrap() {
        return this.obj;
    }

    public String getCode() {
        return this.obj.getCode();
    }

    public String getName() {
        return this.obj.getName();
    }

    public String getTypeCode() {
        return this.obj.getTypeCode();
    }

    public String getTypeName() {
        return this.obj.getTypeName();
    }

    public String getPath() {
        return this.obj.getPath();
    }

    public boolean isRoot() {
        return this.obj.isRoot();
    }

    public boolean isAttrDefined(String code) {
        return this.obj.isAttrDefined(code);
    }

    public boolean isAttrSet(String code) {
        return this.obj.isAttrSet(code);
    }

    public String getCallPath() {
        return this.obj.getCallPath();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RhinoDomainElement[");
        if (this.obj != null) {
            if (this.obj.isRoot()) {
                sb.append('/');
            } else {
                sb.append(this.obj.getTypeCode()).append(':').append(this.obj.getPath());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private String path(HyperonDomainObject o) {
        String str = o != null ? o.getPath() : null;
        return str != null ? str : "";
    }
}

