/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.profiler.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import pl.decerto.hyperon.runtime.profiler.jdbc.JdbcProfiler;

public class PreparedStatementProxy
implements InvocationHandler {
    private static final Class<?>[] INTERFACES = new Class[]{PreparedStatement.class};
    private PreparedStatement ps = null;
    private String sql = null;

    private PreparedStatementProxy(String sql, PreparedStatement ps) {
        this.sql = sql;
        this.ps = ps;
    }

    public static PreparedStatement newInstance(String sql, PreparedStatement ps) {
        return (PreparedStatement)Proxy.newProxyInstance(ps.getClass().getClassLoader(), INTERFACES, (InvocationHandler)new PreparedStatementProxy(sql, ps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long t = System.currentTimeMillis();
        try {
            Object object = method.invoke((Object)this.ps, args);
            return object;
        }
        finally {
            if (method.getName().startsWith("execute")) {
                this.onExecute(t, System.currentTimeMillis());
            }
        }
    }

    private void onExecute(long t1, long t2) {
        JdbcProfiler.getSingleton().sqlExecuted(this.sql, t2 - t1);
    }
}

