/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.profiler.jdbc;

import java.util.Objects;

public class QueryStat
implements Comparable<QueryStat> {
    private String sql;
    private int sqlUid;
    private int count;
    private long totalTime;

    public QueryStat(String sql, int sqlUid) {
        this.sql = sql;
        this.sqlUid = sqlUid;
    }

    public void addMeasure(long time) {
        ++this.count;
        this.totalTime += time;
    }

    public String getSql() {
        return this.sql;
    }

    public String getSqlTrim() {
        return this.sql.trim();
    }

    public int getSqlUid() {
        return this.sqlUid;
    }

    public int getCount() {
        return this.count;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public double getAvg() {
        return (double)this.totalTime / (double)this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryAggregate[");
        sb.append("sqlUid=").append(this.sqlUid);
        sb.append(", count=").append(this.count);
        sb.append(", time=").append(this.totalTime);
        sb.append(String.format(", avg=%.2f", (double)this.totalTime / (double)this.count));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int compareTo(QueryStat o) {
        return (int)(o.totalTime - this.totalTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryStat)) {
            return false;
        }
        QueryStat qs = (QueryStat)o;
        return this.count == qs.count && this.sqlUid == qs.sqlUid;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.sqlUid);
    }
}

