/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.runtime.model.MpScheduleEntry;

public class MpSchedule {
    private final String profileCode;
    private final String region;
    private final List<MpScheduleEntry> entries = new ArrayList<MpScheduleEntry>();

    public MpSchedule(String profileCode, String region) {
        this.profileCode = profileCode;
        this.region = region;
    }

    public void addEntry(MpScheduleEntry e) {
        this.entries.add(e);
        int i = this.entries.size() - 1;
        if (i >= 1) {
            this.entries.get(i - 1).setDateTo(this.entries.get(i).getDateFrom());
        }
    }

    public String getRegion() {
        return this.region;
    }

    public String getProfileCode() {
        return this.profileCode;
    }

    public Optional<MpScheduleEntry> find(Date date) {
        return this.entries.stream().filter(entry -> this.lowerCondition(date, entry.getDateFrom()) && this.upperCondition(date, entry.getDateTo())).findFirst();
    }

    private boolean lowerCondition(Date d, Date lowerBound) {
        return lowerBound == null || lowerBound.getTime() <= d.getTime();
    }

    private boolean upperCondition(Date d, Date upperBound) {
        return upperBound == null || d.getTime() < upperBound.getTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MpSchedule schedule = (MpSchedule)o;
        return Objects.equals(this.profileCode, schedule.profileCode) && Objects.equals(this.region, schedule.region) && Objects.equals(this.entries, schedule.entries);
    }

    public int hashCode() {
        return Objects.hash(this.profileCode, this.region, this.entries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MpSchedule[");
        sb.append("profileCode=").append(this.profileCode);
        sb.append(",region=").append(this.region);
        if (!this.entries.isEmpty()) {
            sb.append(Printer.print(this.entries, "schedule entries"));
        }
        sb.append(']');
        return sb.toString();
    }
}

