/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.license;

import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.types.date.SimpleDateFormatPool;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDetailsDto;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDto;

public class LicensePrintUtils {
    private static final Logger logger = LoggerFactory.getLogger(LicensePrintUtils.class);

    public static void printNoValidLicenseInformation() {
        LicensePrintUtils.printLicenseHeader();
        logger.info("no valid license found!");
        logger.info("visit hyperon.io to obtain license");
        LicensePrintUtils.printLicenseFooter();
    }

    public static void printLicenseNotVerifiedInformation(HyperonLicenseDto license) {
        LicensePrintUtils.printLicenseHeader();
        logger.info("License cannot be verified");
        logger.info("If you think you shouldn't see this information, please contact Hyperon team.");
        logger.info("active license info:");
        LicensePrintUtils.printLicenseInfo(license.getLicenseDetails());
        LicensePrintUtils.printLicenseFooter();
    }

    public static void printLicenseInformation(HyperonLicenseDto license) {
        LicensePrintUtils.printLicenseHeader();
        logger.info("License verified");
        logger.info("active license info:");
        LicensePrintUtils.printLicenseInfo(license.getLicenseDetails());
        LicensePrintUtils.printLicenseFooter();
    }

    private static void printLicenseInfo(HyperonLicenseDetailsDto licenseDetails) {
        SimpleDateFormat dateFormat = SimpleDateFormatPool.get("yyyy-MM-dd");
        logger.info("valid from:" + dateFormat.format(licenseDetails.getValidFrom()));
        if (licenseDetails.getValidTo() != null) {
            logger.info("valid to:" + dateFormat.format(licenseDetails.getValidTo()));
        }
        logger.info("license number:" + licenseDetails.getLicenseNumber());
        logger.info("licensee:" + licenseDetails.getLicensee());
        if (licenseDetails.getPermittedCpuCores() != null) {
            logger.info("permitted cpu cores:" + licenseDetails.getPermittedCpuCores());
        }
        if (licenseDetails.getSpecialConditions() != null) {
            logger.info("special conditions:" + licenseDetails.getSpecialConditions());
        }
    }

    private static void printLicenseHeader() {
        logger.info("===================== LICENSE =====================");
        logger.info("");
    }

    private static void printLicenseFooter() {
        logger.info("");
        logger.info("===================== LICENSE =====================");
    }
}

