/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionInvoker;
import pl.decerto.hyperon.runtime.constants.FunctionCode;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.invoker.RhinoPreprocessor;
import pl.decerto.hyperon.runtime.model.MpRhinoFunction;
import pl.decerto.hyperon.runtime.profiler.engine.EngineProfiler;

public class RhinoFunctionInvoker
implements FunctionInvoker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Integer, org.mozilla.javascript.Function> compileCache = new ConcurrentHashMap<Integer, org.mozilla.javascript.Function>();
    private final Map<String, Object> globalJavaObjects = new ConcurrentHashMap<String, Object>();
    private final EngineProfiler profiler = EngineProfiler.FUNCTION;
    private static final int INITIAL_EXTENT = 256;
    private static final int OPTIMIZATION_LEVEL = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Function function, Object ... args) {
        long t = System.currentTimeMillis();
        try {
            MpRhinoFunction f = this.cast(function);
            Object object = this.call(f, args);
            return object;
        }
        finally {
            this.profiler.addGetMeasure(function.getName(), t, System.currentTimeMillis());
        }
    }

    private MpRhinoFunction cast(Function f) {
        if (f instanceof MpRhinoFunction) {
            return (MpRhinoFunction)f;
        }
        this.logger.error("Unexpected function: {}", (Object)f);
        throw new HyperonRuntimeException("Illegal function passed to RhinoFunctionInvoker: " + f);
    }

    public void invalidate(int functionId) {
        this.logger.debug("invalidating cc for impl.id: {}", (Object)functionId);
        org.mozilla.javascript.Function f = this.compileCache.remove(functionId);
        if (f != null) {
            this.logger.debug("found and invalidated: {}", (Object)f);
        } else {
            this.logger.debug("impl not found in cc");
        }
    }

    public void invalidate() {
        this.logger.debug("invalidating all compiled functions");
        this.compileCache.clear();
    }

    public void addGlobalObject(String code, Object obj) {
        this.globalJavaObjects.put(code, obj);
    }

    public void addGlobalObject(FunctionCode functionCode, Object obj) {
        this.globalJavaObjects.put(functionCode.code(), obj);
    }

    public Map<String, Object> getGlobalObjects() {
        return this.globalJavaObjects;
    }

    private Object call(MpRhinoFunction f, Object ... args) {
        try {
            org.mozilla.javascript.Function js = this.findCompiledFunction(f);
            return this.internalCall(js, args);
        }
        catch (RuntimeException e) {
            throw new HyperonRuntimeException("Rhino function invocation error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalCall(org.mozilla.javascript.Function js, Object ... args) {
        Object result;
        Context cx = Context.enter();
        try {
            Scriptable scope = js.getParentScope();
            result = js.call(cx, scope, scope, args);
        }
        finally {
            Context.exit();
        }
        return this.unwrap(result);
    }

    private org.mozilla.javascript.Function findCompiledFunction(MpRhinoFunction f) {
        org.mozilla.javascript.Function js = this.compileCache.get(f.getImplId());
        if (js == null) {
            js = this.compile(this.createFullBody(f));
            this.compileCache.put(f.getImplId(), js);
        }
        return js;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.mozilla.javascript.Function compile(String fullBody) {
        this.logger.trace("compiling rhino function: \n{}", (Object)fullBody);
        Context cx = Context.enter();
        cx.setOptimizationLevel(9);
        try {
            Scriptable scope = this.initCompileScope(cx);
            org.mozilla.javascript.Function function = cx.compileFunction(scope, fullBody, "", 0, null);
            return function;
        }
        finally {
            Context.exit();
        }
    }

    private Scriptable initCompileScope(Context cx) {
        ScriptableObject scope = cx.initStandardObjects();
        for (Map.Entry<String, Object> e : this.globalJavaObjects.entrySet()) {
            String variableName = e.getKey();
            Object variableObj = e.getValue();
            scope.put(variableName, (Scriptable)scope, Context.javaToJS((Object)variableObj, (Scriptable)scope));
        }
        return scope;
    }

    String createFullBody(MpRhinoFunction f) {
        String body = new RhinoPreprocessor(f.getBody()).preprocess().get();
        StringBuilder sb = new StringBuilder(body.length() + 256);
        sb.append("function ").append(this.internalName(f));
        sb.append('(');
        if (StringUtils.isNotBlank((CharSequence)f.getArgs())) {
            sb.append(f.getArgs());
        }
        sb.append(") {");
        sb.append('\n');
        sb.append(body);
        sb.append('\n');
        this.appendStandardFunctions(sb);
        sb.append('}');
        return sb.toString();
    }

    void appendStandardFunctions(StringBuilder sb) {
        this.appendLine(sb, "//#std::begin");
        this.appendStdFunction(sb, "_integer", "type.getInteger");
        this.appendStdFunction(sb, "_number", "type.getNumber");
        this.appendStdFunction(sb, "_decimal", "type.getDecimal");
        this.appendStdFunction(sb, "_date", "type.getDate");
        this.appendStdFunction(sb, "_boolean", "type.getBoolean");
        this.appendStdFunction(sb, "_string", "type.getString");
        this.appendStdFunction(sb, "_int", "_integer");
        this.appendStdFunction(sb, "_bool", "_boolean");
        this.appendStdFunction(sb, "_str", "_string");
        this.appendStdFunction2arg(sb, "_num", "type.getNumber");
        this.appendStdFunction2arg(sb, "_dec", "type.getDecimal");
        this.appendLine(sb, "//#std::end");
    }

    void appendStdFunction(StringBuilder sb, String f1, String f2) {
        this.appendLine(sb, String.format("function %s(x){return %s(x);}", f1, f2));
    }

    void appendStdFunction2arg(StringBuilder sb, String f1, String f2) {
        this.appendLine(sb, String.format("function %s(x,y){return y===undefined ? %s(x) : %s(x,y);}", f1, f2, f2));
    }

    void appendLine(StringBuilder sb, String line) {
        sb.append(line).append('\n');
    }

    String internalName(MpRhinoFunction f) {
        int id = f.getImplId();
        return (id < 0 ? "T_" : "F_") + Math.abs(id);
    }

    Object unwrap(Object result) {
        if (result instanceof NativeJavaObject) {
            return ((NativeJavaObject)result).unwrap();
        }
        if (result instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)result;
            Object[] array = new Object[(int)nativeArray.getLength()];
            for (Object ix : nativeArray.getIds()) {
                int index = (Integer)ix;
                array[index] = nativeArray.get(index, null);
            }
            return array;
        }
        if (result instanceof Undefined) {
            return null;
        }
        return result;
    }

    public synchronized void initContextFactory(ContextFactory factory) {
        if (!ContextFactory.hasExplicitGlobal()) {
            ContextFactory.initGlobal((ContextFactory)factory);
            this.logger.info("using rhino context factory: {}", (Object)factory);
        }
    }

    public Map<Integer, org.mozilla.javascript.Function> getCompileCacheSnapshot() {
        return new HashMap<Integer, org.mozilla.javascript.Function>(this.compileCache);
    }
}

